/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <WindowInformation.h>
#include <DataNode.h>

// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Init utility for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void WindowInformation::Init()
{
    activeTimeSlider = -1;
    animationMode = 2;
    interactionMode = 0;
    toolUpdateMode = 1;
    boundingBoxNavigate = true;
    spin = false;
    fullFrame = false;
    perspective = true;
    maintainView = false;
    lockView = false;
    lockTools = false;
    lockTime = false;
    viewExtentsType = 0;
    viewDimension = 2;
    cameraViewMode = false;
    usingScalableRendering = false;
    lastRenderMin = 0;
    lastRenderAvg = 0;
    lastRenderMax = 0;
    numPrimitives = 0;
    extents[0] = 0;
    extents[1] = 0;
    extents[2] = 0;
    extents[3] = 0;
    extents[4] = 0;
    extents[5] = 0;
    windowSize[0] = 0;
    windowSize[1] = 0;
    winMode = 0;

    WindowInformation::SelectAll();
}

// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Copy utility for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void WindowInformation::Copy(const WindowInformation &obj)
{

    activeSource = obj.activeSource;
    activeTimeSlider = obj.activeTimeSlider;
    timeSliders = obj.timeSliders;
    timeSliderCurrentStates = obj.timeSliderCurrentStates;
    animationMode = obj.animationMode;
    interactionMode = obj.interactionMode;
    toolUpdateMode = obj.toolUpdateMode;
    boundingBoxNavigate = obj.boundingBoxNavigate;
    spin = obj.spin;
    fullFrame = obj.fullFrame;
    perspective = obj.perspective;
    maintainView = obj.maintainView;
    lockView = obj.lockView;
    lockTools = obj.lockTools;
    lockTime = obj.lockTime;
    viewExtentsType = obj.viewExtentsType;
    viewDimension = obj.viewDimension;
    viewKeyframes = obj.viewKeyframes;
    cameraViewMode = obj.cameraViewMode;
    usingScalableRendering = obj.usingScalableRendering;
    lastRenderMin = obj.lastRenderMin;
    lastRenderAvg = obj.lastRenderAvg;
    lastRenderMax = obj.lastRenderMax;
    numPrimitives = obj.numPrimitives;
    for(int i = 0; i < 6; ++i)
        extents[i] = obj.extents[i];

    windowSize[0] = obj.windowSize[0];
    windowSize[1] = obj.windowSize[1];

    winMode = obj.winMode;

    WindowInformation::SelectAll();
}

// Type map format string
const char *WindowInformation::TypeMapFormatString = WINDOWINFORMATION_TMFS;
const AttributeGroup::private_tmfs_t WindowInformation::TmfsStruct = {WINDOWINFORMATION_TMFS};


// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Default constructor for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::WindowInformation() : 
    AttributeSubject(WindowInformation::TypeMapFormatString)
{
    WindowInformation::Init();
}

// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Constructor for the derived classes of WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::WindowInformation(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    WindowInformation::Init();
}

// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Copy constructor for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::WindowInformation(const WindowInformation &obj) : 
    AttributeSubject(WindowInformation::TypeMapFormatString)
{
    WindowInformation::Copy(obj);
}

// ****************************************************************************
// Method: WindowInformation::WindowInformation
//
// Purpose: 
//   Copy constructor for derived classes of the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::WindowInformation(const WindowInformation &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    WindowInformation::Copy(obj);
}

// ****************************************************************************
// Method: WindowInformation::~WindowInformation
//
// Purpose: 
//   Destructor for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowInformation::~WindowInformation()
{
    // nothing here
}

// ****************************************************************************
// Method: WindowInformation::operator = 
//
// Purpose: 
//   Assignment operator for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

WindowInformation& 
WindowInformation::operator = (const WindowInformation &obj)
{
    if (this == &obj) return *this;

    WindowInformation::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: WindowInformation::operator == 
//
// Purpose: 
//   Comparison operator == for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::operator == (const WindowInformation &obj) const
{
    // Compare the extents arrays.
    bool extents_equal = true;
    for(int i = 0; i < 6 && extents_equal; ++i)
        extents_equal = (extents[i] == obj.extents[i]);

    // Compare the windowSize arrays.
    bool windowSize_equal = true;
    for(int i = 0; i < 2 && windowSize_equal; ++i)
        windowSize_equal = (windowSize[i] == obj.windowSize[i]);

    // Create the return value
    return ((activeSource == obj.activeSource) &&
            (activeTimeSlider == obj.activeTimeSlider) &&
            (timeSliders == obj.timeSliders) &&
            (timeSliderCurrentStates == obj.timeSliderCurrentStates) &&
            (animationMode == obj.animationMode) &&
            (interactionMode == obj.interactionMode) &&
            (toolUpdateMode == obj.toolUpdateMode) &&
            (boundingBoxNavigate == obj.boundingBoxNavigate) &&
            (spin == obj.spin) &&
            (fullFrame == obj.fullFrame) &&
            (perspective == obj.perspective) &&
            (maintainView == obj.maintainView) &&
            (lockView == obj.lockView) &&
            (lockTools == obj.lockTools) &&
            (lockTime == obj.lockTime) &&
            (viewExtentsType == obj.viewExtentsType) &&
            (viewDimension == obj.viewDimension) &&
            (viewKeyframes == obj.viewKeyframes) &&
            (cameraViewMode == obj.cameraViewMode) &&
            (usingScalableRendering == obj.usingScalableRendering) &&
            (lastRenderMin == obj.lastRenderMin) &&
            (lastRenderAvg == obj.lastRenderAvg) &&
            (lastRenderMax == obj.lastRenderMax) &&
            (numPrimitives == obj.numPrimitives) &&
            extents_equal &&
            windowSize_equal &&
            (winMode == obj.winMode));
}

// ****************************************************************************
// Method: WindowInformation::operator != 
//
// Purpose: 
//   Comparison operator != for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::operator != (const WindowInformation &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: WindowInformation::TypeName
//
// Purpose: 
//   Type name method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
WindowInformation::TypeName() const
{
    return "WindowInformation";
}

// ****************************************************************************
// Method: WindowInformation::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const WindowInformation *tmp = (const WindowInformation *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: WindowInformation::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowInformation::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new WindowInformation(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: WindowInformation::NewInstance
//
// Purpose: 
//   NewInstance method for the WindowInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
WindowInformation::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new WindowInformation(*this);
    else
        retval = new WindowInformation;

    return retval;
}

// ****************************************************************************
// Method: WindowInformation::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
WindowInformation::SelectAll()
{
    Select(ID_activeSource,            (void *)&activeSource);
    Select(ID_activeTimeSlider,        (void *)&activeTimeSlider);
    Select(ID_timeSliders,             (void *)&timeSliders);
    Select(ID_timeSliderCurrentStates, (void *)&timeSliderCurrentStates);
    Select(ID_animationMode,           (void *)&animationMode);
    Select(ID_interactionMode,         (void *)&interactionMode);
    Select(ID_toolUpdateMode,          (void *)&toolUpdateMode);
    Select(ID_boundingBoxNavigate,     (void *)&boundingBoxNavigate);
    Select(ID_spin,                    (void *)&spin);
    Select(ID_fullFrame,               (void *)&fullFrame);
    Select(ID_perspective,             (void *)&perspective);
    Select(ID_maintainView,            (void *)&maintainView);
    Select(ID_lockView,                (void *)&lockView);
    Select(ID_lockTools,               (void *)&lockTools);
    Select(ID_lockTime,                (void *)&lockTime);
    Select(ID_viewExtentsType,         (void *)&viewExtentsType);
    Select(ID_viewDimension,           (void *)&viewDimension);
    Select(ID_viewKeyframes,           (void *)&viewKeyframes);
    Select(ID_cameraViewMode,          (void *)&cameraViewMode);
    Select(ID_usingScalableRendering,  (void *)&usingScalableRendering);
    Select(ID_lastRenderMin,           (void *)&lastRenderMin);
    Select(ID_lastRenderAvg,           (void *)&lastRenderAvg);
    Select(ID_lastRenderMax,           (void *)&lastRenderMax);
    Select(ID_numPrimitives,           (void *)&numPrimitives);
    Select(ID_extents,                 (void *)extents, 6);
    Select(ID_windowSize,              (void *)windowSize, 2);
    Select(ID_winMode,                 (void *)&winMode);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowInformation::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Sep 16 14:03:15 PST 2002
//
// Modifications:
//   Brad Whitlock, Tue Nov 12 14:53:00 PST 2002
//   I added lockTools and lockTime.
//
//   Eric Brugger, Fri Apr 18 10:42:07 PDT 2003
//   I removed autoCenterView.
//
//   Brad Whitlock, Tue May 20 10:27:57 PDT 2003
//   I made it save only the fields that differ from the defaults. Added
//   fullFrame.
//
//   Brad Whitlock, Wed Dec 17 12:07:27 PDT 2003
//   I added a completeSave argument.
//
//   Brad Whitlock, Fri Jan 23 16:21:10 PST 2004
//   I changed the attribute numbering.
//
//   Brad Whitlock, Fri Dec 14 15:59:21 PST 2007
//   Made it use ids.
//
// ****************************************************************************

bool
WindowInformation::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    bool              addToParent = false;
    WindowInformation defaultObject;

    // Create a node for WindowInformation.
    DataNode *node = new DataNode("WindowInformation");

    if(completeSave || !FieldsEqual(ID_boundingBoxNavigate, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("boundingBoxNavigate", boundingBoxNavigate));
    }

    if(completeSave || !FieldsEqual(ID_fullFrame, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fullFrame", fullFrame));
    }

    if(completeSave || !FieldsEqual(ID_perspective, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("perspective", perspective));
    }

    if(completeSave || !FieldsEqual(ID_lockView, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lockView", lockView));
    }

    if(completeSave || !FieldsEqual(ID_lockTools, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lockTools", lockTools));
    }

    if(completeSave || !FieldsEqual(ID_lockTime, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lockTime", lockTime));
    }

    if(completeSave || !FieldsEqual(ID_viewExtentsType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewExtentsType", viewExtentsType));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: WindowInformation::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Sep 16 14:03:15 PST 2002
//
// Modifications:
//   Brad Whitlock, Tue Nov 12 14:53:00 PST 2002
//   I added lockTools and lockTime.
//
//   Brad Whitlock, Wed May 21 07:30:04 PDT 2003
//   I added fullFrame.
//   
// ****************************************************************************

void
WindowInformation::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("WindowInformation");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("boundingBoxNavigate")) != 0)
        SetBoundingBoxNavigate(node->AsBool());
    if((node = searchNode->GetNode("perspective")) != 0)
        SetPerspective(node->AsBool());
    if((node = searchNode->GetNode("viewExtentsType")) != 0)
        SetViewExtentsType(node->AsInt());
    if((node = searchNode->GetNode("lockView")) != 0)
        SetLockView(node->AsBool());
    if((node = searchNode->GetNode("lockTime")) != 0)
        SetLockTime(node->AsBool());
    if((node = searchNode->GetNode("lockTools")) != 0)
        SetLockTools(node->AsBool());
    if((node = searchNode->GetNode("fullFrame")) != 0)
        SetFullFrame(node->AsBool());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowInformation::SetActiveSource(const std::string &activeSource_)
{
    activeSource = activeSource_;
    Select(ID_activeSource, (void *)&activeSource);
}

void
WindowInformation::SetActiveTimeSlider(int activeTimeSlider_)
{
    activeTimeSlider = activeTimeSlider_;
    Select(ID_activeTimeSlider, (void *)&activeTimeSlider);
}

void
WindowInformation::SetTimeSliders(const stringVector &timeSliders_)
{
    timeSliders = timeSliders_;
    Select(ID_timeSliders, (void *)&timeSliders);
}

void
WindowInformation::SetTimeSliderCurrentStates(const intVector &timeSliderCurrentStates_)
{
    timeSliderCurrentStates = timeSliderCurrentStates_;
    Select(ID_timeSliderCurrentStates, (void *)&timeSliderCurrentStates);
}

void
WindowInformation::SetAnimationMode(int animationMode_)
{
    animationMode = animationMode_;
    Select(ID_animationMode, (void *)&animationMode);
}

void
WindowInformation::SetInteractionMode(int interactionMode_)
{
    interactionMode = interactionMode_;
    Select(ID_interactionMode, (void *)&interactionMode);
}

void
WindowInformation::SetToolUpdateMode(int toolUpdateMode_)
{
    toolUpdateMode = toolUpdateMode_;
    Select(ID_toolUpdateMode, (void *)&toolUpdateMode);
}

void
WindowInformation::SetBoundingBoxNavigate(bool boundingBoxNavigate_)
{
    boundingBoxNavigate = boundingBoxNavigate_;
    Select(ID_boundingBoxNavigate, (void *)&boundingBoxNavigate);
}

void
WindowInformation::SetSpin(bool spin_)
{
    spin = spin_;
    Select(ID_spin, (void *)&spin);
}

void
WindowInformation::SetFullFrame(bool fullFrame_)
{
    fullFrame = fullFrame_;
    Select(ID_fullFrame, (void *)&fullFrame);
}

void
WindowInformation::SetPerspective(bool perspective_)
{
    perspective = perspective_;
    Select(ID_perspective, (void *)&perspective);
}

void
WindowInformation::SetMaintainView(bool maintainView_)
{
    maintainView = maintainView_;
    Select(ID_maintainView, (void *)&maintainView);
}

void
WindowInformation::SetLockView(bool lockView_)
{
    lockView = lockView_;
    Select(ID_lockView, (void *)&lockView);
}

void
WindowInformation::SetLockTools(bool lockTools_)
{
    lockTools = lockTools_;
    Select(ID_lockTools, (void *)&lockTools);
}

void
WindowInformation::SetLockTime(bool lockTime_)
{
    lockTime = lockTime_;
    Select(ID_lockTime, (void *)&lockTime);
}

void
WindowInformation::SetViewExtentsType(int viewExtentsType_)
{
    viewExtentsType = viewExtentsType_;
    Select(ID_viewExtentsType, (void *)&viewExtentsType);
}

void
WindowInformation::SetViewDimension(int viewDimension_)
{
    viewDimension = viewDimension_;
    Select(ID_viewDimension, (void *)&viewDimension);
}

void
WindowInformation::SetViewKeyframes(const intVector &viewKeyframes_)
{
    viewKeyframes = viewKeyframes_;
    Select(ID_viewKeyframes, (void *)&viewKeyframes);
}

void
WindowInformation::SetCameraViewMode(bool cameraViewMode_)
{
    cameraViewMode = cameraViewMode_;
    Select(ID_cameraViewMode, (void *)&cameraViewMode);
}

void
WindowInformation::SetUsingScalableRendering(bool usingScalableRendering_)
{
    usingScalableRendering = usingScalableRendering_;
    Select(ID_usingScalableRendering, (void *)&usingScalableRendering);
}

void
WindowInformation::SetLastRenderMin(float lastRenderMin_)
{
    lastRenderMin = lastRenderMin_;
    Select(ID_lastRenderMin, (void *)&lastRenderMin);
}

void
WindowInformation::SetLastRenderAvg(float lastRenderAvg_)
{
    lastRenderAvg = lastRenderAvg_;
    Select(ID_lastRenderAvg, (void *)&lastRenderAvg);
}

void
WindowInformation::SetLastRenderMax(float lastRenderMax_)
{
    lastRenderMax = lastRenderMax_;
    Select(ID_lastRenderMax, (void *)&lastRenderMax);
}

void
WindowInformation::SetNumPrimitives(int numPrimitives_)
{
    numPrimitives = numPrimitives_;
    Select(ID_numPrimitives, (void *)&numPrimitives);
}

void
WindowInformation::SetExtents(const double *extents_)
{
    for(int i = 0; i < 6; ++i)
        extents[i] = extents_[i];
    Select(ID_extents, (void *)extents, 6);
}

void
WindowInformation::SetWindowSize(const int *windowSize_)
{
    windowSize[0] = windowSize_[0];
    windowSize[1] = windowSize_[1];
    Select(ID_windowSize, (void *)windowSize, 2);
}

void
WindowInformation::SetWinMode(int winMode_)
{
    winMode = winMode_;
    Select(ID_winMode, (void *)&winMode);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
WindowInformation::GetActiveSource() const
{
    return activeSource;
}

std::string &
WindowInformation::GetActiveSource()
{
    return activeSource;
}

int
WindowInformation::GetActiveTimeSlider() const
{
    return activeTimeSlider;
}

const stringVector &
WindowInformation::GetTimeSliders() const
{
    return timeSliders;
}

stringVector &
WindowInformation::GetTimeSliders()
{
    return timeSliders;
}

const intVector &
WindowInformation::GetTimeSliderCurrentStates() const
{
    return timeSliderCurrentStates;
}

intVector &
WindowInformation::GetTimeSliderCurrentStates()
{
    return timeSliderCurrentStates;
}

int
WindowInformation::GetAnimationMode() const
{
    return animationMode;
}

int
WindowInformation::GetInteractionMode() const
{
    return interactionMode;
}

int
WindowInformation::GetToolUpdateMode() const
{
    return toolUpdateMode;
}

bool
WindowInformation::GetBoundingBoxNavigate() const
{
    return boundingBoxNavigate;
}

bool
WindowInformation::GetSpin() const
{
    return spin;
}

bool
WindowInformation::GetFullFrame() const
{
    return fullFrame;
}

bool
WindowInformation::GetPerspective() const
{
    return perspective;
}

bool
WindowInformation::GetMaintainView() const
{
    return maintainView;
}

bool
WindowInformation::GetLockView() const
{
    return lockView;
}

bool
WindowInformation::GetLockTools() const
{
    return lockTools;
}

bool
WindowInformation::GetLockTime() const
{
    return lockTime;
}

int
WindowInformation::GetViewExtentsType() const
{
    return viewExtentsType;
}

int
WindowInformation::GetViewDimension() const
{
    return viewDimension;
}

const intVector &
WindowInformation::GetViewKeyframes() const
{
    return viewKeyframes;
}

intVector &
WindowInformation::GetViewKeyframes()
{
    return viewKeyframes;
}

bool
WindowInformation::GetCameraViewMode() const
{
    return cameraViewMode;
}

bool
WindowInformation::GetUsingScalableRendering() const
{
    return usingScalableRendering;
}

float
WindowInformation::GetLastRenderMin() const
{
    return lastRenderMin;
}

float
WindowInformation::GetLastRenderAvg() const
{
    return lastRenderAvg;
}

float
WindowInformation::GetLastRenderMax() const
{
    return lastRenderMax;
}

int
WindowInformation::GetNumPrimitives() const
{
    return numPrimitives;
}

const double *
WindowInformation::GetExtents() const
{
    return extents;
}

double *
WindowInformation::GetExtents()
{
    return extents;
}

const int *
WindowInformation::GetWindowSize() const
{
    return windowSize;
}

int *
WindowInformation::GetWindowSize()
{
    return windowSize;
}

int
WindowInformation::GetWinMode() const
{
    return winMode;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
WindowInformation::SelectActiveSource()
{
    Select(ID_activeSource, (void *)&activeSource);
}

void
WindowInformation::SelectTimeSliders()
{
    Select(ID_timeSliders, (void *)&timeSliders);
}

void
WindowInformation::SelectTimeSliderCurrentStates()
{
    Select(ID_timeSliderCurrentStates, (void *)&timeSliderCurrentStates);
}

void
WindowInformation::SelectViewKeyframes()
{
    Select(ID_viewKeyframes, (void *)&viewKeyframes);
}

void
WindowInformation::SelectExtents()
{
    Select(ID_extents, (void *)extents, 6);
}

void
WindowInformation::SelectWindowSize()
{
    Select(ID_windowSize, (void *)windowSize, 2);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: WindowInformation::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowInformation::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_activeSource:            return "activeSource";
    case ID_activeTimeSlider:        return "activeTimeSlider";
    case ID_timeSliders:             return "timeSliders";
    case ID_timeSliderCurrentStates: return "timeSliderCurrentStates";
    case ID_animationMode:           return "animationMode";
    case ID_interactionMode:         return "interactionMode";
    case ID_toolUpdateMode:          return "toolUpdateMode";
    case ID_boundingBoxNavigate:     return "boundingBoxNavigate";
    case ID_spin:                    return "spin";
    case ID_fullFrame:               return "fullFrame";
    case ID_perspective:             return "perspective";
    case ID_maintainView:            return "maintainView";
    case ID_lockView:                return "lockView";
    case ID_lockTools:               return "lockTools";
    case ID_lockTime:                return "lockTime";
    case ID_viewExtentsType:         return "viewExtentsType";
    case ID_viewDimension:           return "viewDimension";
    case ID_viewKeyframes:           return "viewKeyframes";
    case ID_cameraViewMode:          return "cameraViewMode";
    case ID_usingScalableRendering:  return "usingScalableRendering";
    case ID_lastRenderMin:           return "lastRenderMin";
    case ID_lastRenderAvg:           return "lastRenderAvg";
    case ID_lastRenderMax:           return "lastRenderMax";
    case ID_numPrimitives:           return "numPrimitives";
    case ID_extents:                 return "extents";
    case ID_windowSize:              return "windowSize";
    case ID_winMode:                 return "winMode";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowInformation::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
WindowInformation::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_activeSource:            return FieldType_string;
    case ID_activeTimeSlider:        return FieldType_int;
    case ID_timeSliders:             return FieldType_stringVector;
    case ID_timeSliderCurrentStates: return FieldType_intVector;
    case ID_animationMode:           return FieldType_int;
    case ID_interactionMode:         return FieldType_int;
    case ID_toolUpdateMode:          return FieldType_int;
    case ID_boundingBoxNavigate:     return FieldType_bool;
    case ID_spin:                    return FieldType_bool;
    case ID_fullFrame:               return FieldType_bool;
    case ID_perspective:             return FieldType_bool;
    case ID_maintainView:            return FieldType_bool;
    case ID_lockView:                return FieldType_bool;
    case ID_lockTools:               return FieldType_bool;
    case ID_lockTime:                return FieldType_bool;
    case ID_viewExtentsType:         return FieldType_int;
    case ID_viewDimension:           return FieldType_int;
    case ID_viewKeyframes:           return FieldType_intVector;
    case ID_cameraViewMode:          return FieldType_bool;
    case ID_usingScalableRendering:  return FieldType_bool;
    case ID_lastRenderMin:           return FieldType_float;
    case ID_lastRenderAvg:           return FieldType_float;
    case ID_lastRenderMax:           return FieldType_float;
    case ID_numPrimitives:           return FieldType_int;
    case ID_extents:                 return FieldType_doubleArray;
    case ID_windowSize:              return FieldType_intArray;
    case ID_winMode:                 return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: WindowInformation::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
WindowInformation::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_activeSource:            return "string";
    case ID_activeTimeSlider:        return "int";
    case ID_timeSliders:             return "stringVector";
    case ID_timeSliderCurrentStates: return "intVector";
    case ID_animationMode:           return "int";
    case ID_interactionMode:         return "int";
    case ID_toolUpdateMode:          return "int";
    case ID_boundingBoxNavigate:     return "bool";
    case ID_spin:                    return "bool";
    case ID_fullFrame:               return "bool";
    case ID_perspective:             return "bool";
    case ID_maintainView:            return "bool";
    case ID_lockView:                return "bool";
    case ID_lockTools:               return "bool";
    case ID_lockTime:                return "bool";
    case ID_viewExtentsType:         return "int";
    case ID_viewDimension:           return "int";
    case ID_viewKeyframes:           return "intVector";
    case ID_cameraViewMode:          return "bool";
    case ID_usingScalableRendering:  return "bool";
    case ID_lastRenderMin:           return "float";
    case ID_lastRenderAvg:           return "float";
    case ID_lastRenderMax:           return "float";
    case ID_numPrimitives:           return "int";
    case ID_extents:                 return "doubleArray";
    case ID_windowSize:              return "intArray";
    case ID_winMode:                 return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: WindowInformation::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
WindowInformation::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const WindowInformation &obj = *((const WindowInformation*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_activeSource:
        {  // new scope
        retval = (activeSource == obj.activeSource);
        }
        break;
    case ID_activeTimeSlider:
        {  // new scope
        retval = (activeTimeSlider == obj.activeTimeSlider);
        }
        break;
    case ID_timeSliders:
        {  // new scope
        retval = (timeSliders == obj.timeSliders);
        }
        break;
    case ID_timeSliderCurrentStates:
        {  // new scope
        retval = (timeSliderCurrentStates == obj.timeSliderCurrentStates);
        }
        break;
    case ID_animationMode:
        {  // new scope
        retval = (animationMode == obj.animationMode);
        }
        break;
    case ID_interactionMode:
        {  // new scope
        retval = (interactionMode == obj.interactionMode);
        }
        break;
    case ID_toolUpdateMode:
        {  // new scope
        retval = (toolUpdateMode == obj.toolUpdateMode);
        }
        break;
    case ID_boundingBoxNavigate:
        {  // new scope
        retval = (boundingBoxNavigate == obj.boundingBoxNavigate);
        }
        break;
    case ID_spin:
        {  // new scope
        retval = (spin == obj.spin);
        }
        break;
    case ID_fullFrame:
        {  // new scope
        retval = (fullFrame == obj.fullFrame);
        }
        break;
    case ID_perspective:
        {  // new scope
        retval = (perspective == obj.perspective);
        }
        break;
    case ID_maintainView:
        {  // new scope
        retval = (maintainView == obj.maintainView);
        }
        break;
    case ID_lockView:
        {  // new scope
        retval = (lockView == obj.lockView);
        }
        break;
    case ID_lockTools:
        {  // new scope
        retval = (lockTools == obj.lockTools);
        }
        break;
    case ID_lockTime:
        {  // new scope
        retval = (lockTime == obj.lockTime);
        }
        break;
    case ID_viewExtentsType:
        {  // new scope
        retval = (viewExtentsType == obj.viewExtentsType);
        }
        break;
    case ID_viewDimension:
        {  // new scope
        retval = (viewDimension == obj.viewDimension);
        }
        break;
    case ID_viewKeyframes:
        {  // new scope
        retval = (viewKeyframes == obj.viewKeyframes);
        }
        break;
    case ID_cameraViewMode:
        {  // new scope
        retval = (cameraViewMode == obj.cameraViewMode);
        }
        break;
    case ID_usingScalableRendering:
        {  // new scope
        retval = (usingScalableRendering == obj.usingScalableRendering);
        }
        break;
    case ID_lastRenderMin:
        {  // new scope
        retval = (lastRenderMin == obj.lastRenderMin);
        }
        break;
    case ID_lastRenderAvg:
        {  // new scope
        retval = (lastRenderAvg == obj.lastRenderAvg);
        }
        break;
    case ID_lastRenderMax:
        {  // new scope
        retval = (lastRenderMax == obj.lastRenderMax);
        }
        break;
    case ID_numPrimitives:
        {  // new scope
        retval = (numPrimitives == obj.numPrimitives);
        }
        break;
    case ID_extents:
        {  // new scope
        // Compare the extents arrays.
        bool extents_equal = true;
        for(int i = 0; i < 6 && extents_equal; ++i)
            extents_equal = (extents[i] == obj.extents[i]);

        retval = extents_equal;
        }
        break;
    case ID_windowSize:
        {  // new scope
        // Compare the windowSize arrays.
        bool windowSize_equal = true;
        for(int i = 0; i < 2 && windowSize_equal; ++i)
            windowSize_equal = (windowSize[i] == obj.windowSize[i]);

        retval = windowSize_equal;
        }
        break;
    case ID_winMode:
        {  // new scope
        retval = (winMode == obj.winMode);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

