/***************************************************************************
                          systemtray.cpp  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <KApplication>
#include <KLocale>
#include <KWindowSystem>
#include <QIcon>
#include <QMessageBox>
#include <KMessageBox>

#include "systemtray.h"

//#include "variables.h"   //ooo

SystemTray::SystemTray(QWidget *parent/*, KAboutData *aboutData*/)
   : KSystemTrayIcon("qtrans")
{
	Par = parent;

	//aboutApplicationDialog = new KAboutApplicationDialog(aboutData);

	//Initialize actions
	aboutApplicationAct = new KAction(KIcon("help-about"), i18n("About QTrans"), this);
	aboutApplicationAct->setIconVisibleInMenu(true);
	settingsAct = new KAction(KIcon("configure"), i18n("&Settings"), this);
	settingsAct->setIconVisibleInMenu(true);
	disableAct = new KAction(i18n("&Disable"), this);
	enableAct = new KAction(i18n("&Enable"), this);
	exitAct = new KAction(KIcon("application-exit"), i18n("&Quit"), this);
	exitAct->setIconVisibleInMenu(true);

	// Connect actions
	//connect(aboutApplicationAct, SIGNAL(triggered(bool)), aboutApplicationDialog, SLOT(show()));
	connect(aboutApplicationAct, SIGNAL(triggered(bool)), Par, SLOT(slot_About()));
	connect(settingsAct, SIGNAL(triggered(bool)), Par, SLOT(slot_Config()));
	connect(disableAct, SIGNAL(triggered(bool)), Par, SLOT(slot_Enable()));
	connect(enableAct, SIGNAL(triggered(bool)), Par, SLOT(slot_Enable()));
	connect(disableAct, SIGNAL(triggered(bool)), this, SLOT(disable_application()));
	connect(enableAct, SIGNAL(triggered(bool)), this, SLOT(enable_application()));
	connect(exitAct, SIGNAL(triggered(bool)), Par, SLOT(slot_Exit()));

	// Add them to menu
/*	contextMenu()->addAction(aboutApplicationAct);
	contextMenu()->addAction(settingsAct);
	contextMenu()->addAction(disableAct);
	contextMenu()->addAction(enableAct);
	enableAct->setVisible(false);
*/
	systemTrayIconMenu = new KMenu(Par);

	systemTrayIconMenu->addTitle(KIcon("qtrans"), tr("QTrans"));
	systemTrayIconMenu->addAction(aboutApplicationAct);
	systemTrayIconMenu->addAction(settingsAct);
	systemTrayIconMenu->addAction(disableAct);
	systemTrayIconMenu->addAction(enableAct);
	systemTrayIconMenu->addSeparator();
	systemTrayIconMenu->addAction(exitAct);
	enableAct->setVisible(false);
	setContextMenu(systemTrayIconMenu);

	// Initialize variables
	application_enabled = true;
	//aboutApplicationDialog->setInitialSize( QSize( 350, 350 ) );
	normalIcon = icon();
	grayIcon.addPixmap(icon().pixmap(22, 22, QIcon::Disabled));

	//connect(this, SIGNAL(messageClicked()), SLOT(messageClicked()));
	connect(this, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
            SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));

}


SystemTray::~SystemTray()
{
}


void SystemTray::disable_application()
{
    if ( is_enabled() )
    {
        //KMessageBox::sorry(0, i18n("QTrans will be desabled..."));

        // Convert trayIcon to gray
        //setIcon(grayIcon);
	setIcon(KIcon("qtrans-disabled"));

        application_enabled = false;
    }
}


void SystemTray::enable_application()
{
    if (!is_enabled())
    {
        //KMessageBox::information(0, i18n("QTrans will be enabled..."));

        setIcon(normalIcon);
        application_enabled = true;
    }
}


bool SystemTray::is_enabled()
{
    return application_enabled;
}


void SystemTray::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
	switch (reason) {
	case QSystemTrayIcon::Trigger:
		if ( Par->isVisible() ) {
			Par->hide();
		} else {
			if ( !KWindowSystem::windowInfo(Par->winId(), NET::WMDesktop).isOnCurrentDesktop() ) {
				KWindowSystem::setOnDesktop(Par->winId(), KWindowSystem::currentDesktop());
			}
			Par->show();
			if (hideTask) {
				KWindowSystem::setState(Par->winId(),NET::SkipTaskbar);
				//QMessageBox::about(Par, tr("About Diagram Scene"), tr("iconActivated(: 2a"));
			} else {
				KWindowSystem::clearState(Par->winId(),NET::SkipTaskbar);
				//QMessageBox::about(Par, tr("About Diagram Scene"), tr("iconActivated(: 2b"));
			}

			KWindowSystem::activateWindow(Par->winId());
		}
		break;
	case QSystemTrayIcon::DoubleClick:
		//iconComboBox->setCurrentIndex((iconComboBox->currentIndex() + 1)
		//                              % iconComboBox->count());
/*		if ( !KWindowSystem::windowInfo(winId(), NET::WMDesktop).isOnCurrentDesktop() ) {
			KWindowSystem::setOnDesktop(winId(), KWindowSystem::currentDesktop());
		}
		KWindowSystem::activateWindow(winId());
*/		break;
	case QSystemTrayIcon::MiddleClick:
		//showMessage();
		break;
	case QSystemTrayIcon::Context:
		//trayIcon->showMessage(tr("QTrans"), tr("Babylon translator"), QSystemTrayIcon::Information, 10000);
		break;
	default:
        	break;
	}
}

#include "systemtray.moc"
