/***************************************************************************
                          stardict.h  -  description

                             -------------------
    begin                : 27. November 2009
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef STARDICT_H
#define STARDICT_H

//#include <cstdio>	//ooo
#include <QFile>
#include <QString>
#include <QTextStream>	//ooo
#include <QDataStream>	//ooo
#include <QList>

#include <string>

#define BUFFERSIZE 10240	//ooo

class StarDict {
public:
	StarDict(const QString &filename, bool wholeStarDict, bool wholeWordsOnly, bool wordStartsWith);

	~StarDict();

	QString printMessage();
	//bool open();
	//void Info_Ifo(FILE & f);
	void Info_Ifo(QFile & file);
	void Info_Idx(QFile & file);

	bool b_wholeStarDict;
	bool b_wholeWordsOnly;
	bool b_wordStartsWith;
	std::string p_filename;
	QString filename() const { return m_filename; };
	QString search( const QString & );
	char* Inflate( unsigned char *data, unsigned long size);	//ooo
	QString parseData(const char *data);				//ooo
	//FILE *f;
	QFile *f;
	int wordcount;
	int idxfilesize;
	//QString wordcount;
	//QString idxfilesize;

protected:
	void readExtraField();
	void readFileName();

	int headerLength;	//ooo
	bool isCompressed;
	QFile *ifoFile;
	QFile *idxFile;
	QFile *dictFile;

	int CM;
	char FLAGS;
	//unsigned char FLAGS;		//ooo
	bool FTEXT;
	bool FHCRC;
	bool FEXTRA;			// Extra field		//ooo
	bool FNAME;			// original file name
	bool FCOMMENT;			// file comment

	unsigned long MTIME;		// Modification TIME
	int XFL;			// eXtra FLags		//ooo
	int OS;				// Operating System	//ooo
	unsigned long XLEN;		// eXtra LENgth
	//int XLEN;	//ooo
	char SI1, SI2;
	//unsigned long LEN, VER, CHLEN, CHCNT;
	int LEN, VER, CHLEN, CHCNT;	//ooo
	QList<unsigned long> offsets;
	QList<unsigned long> offsetsWithHeader;	//ooo
	QString m_filename;
	std::string origFilename;	//ooo
	std::string comment;		//ooo
	char *crc16[2];
	//unsigned char *crc16[2];	//ooo
	unsigned long offset;
	unsigned long offsetAdditional;		//ooo

	char c;
	int type;			//ooo
	char buffer[BUFFERSIZE];	//ooo
	char *byte;			//ooo

	// ifo file
	QString m_version;
	QString m_bookname;
	uint m_wordcount;
	ulong m_idxfilesize;
	QString m_sametypesequence;
	QString m_author;
	QString m_email;
	QString m_website;
	QString m_description;
	QString m_date;

	struct entry{
		unsigned long position;
		unsigned long size;
		//unsigned int size;
	};
	
	QList <QString> headwords;	//ooo
	//QList <entry> entries;		//ooo
	QList <unsigned long> positions;	//ooo
	QList <unsigned long> sizes;		//ooo

};

#endif // STARDICT_H
