/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <KCmdLineArgs>
#include <kdebug.h>
#include <kuniqueapplication.h>
#include <kdialog.h>
#include <QWidget>
#include <KAboutData>

#include "qtrans.h"
#include "utils.h"
#include "babylon.h"
#include "systemtray.h"
//#include "variables.h"   //ooo

#include <KStyle>	//ooo
#include <QStyleFactory>	//ooo
//#include <QTextStream>	//ooo



/*
static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};
*/
int main(int argc, char **argv)
{

	//QApplication::setDesktopSettingsAware(false);   //ooo
	KCmdLineOptions options;
/*	options.add("debug", ki18n("Keep output results from scripts"));
	options.add("check <update-file>", ki18n("Check whether config file itself requires updating"));
	options.add("+[file]", ki18n("File to read update instructions from"));
*/
	options.add("+[URL]", ki18n("Document to open"));

	KAboutData *aboutData = new KAboutData("qtrans",            // The program name used internally.
		0,                                                  // The message catalog name, use program name if null.
		ki18n(Q_NAME),                                      // A displayable program name string.
		Q_VERSION,                                          // The program version string.
		ki18n(Q_DESCRIPTION),                               // A short description of what the program does.
		KAboutData::License_GPL,                            // License identifier
		ki18n("Copyright (c) 2007-2012 Iven Wold"),     // Copyright Statement
		ki18n(""),                                          // Some free form text, that can contain any kind of information.
		"",                                                 // The program homepage string.
		"submit@bugs.kde.org");                             // The bug report email address string.

	//aboutData->addAuthor( ki18n("Matteo Merli"), ki18n("Original author"), "merlim@libero.it" );
	aboutData->addAuthor( ki18n("Iven Wold"), KLocalizedString(), "hour.glass2@yahoo.com" );
	//aboutData->addAuthor( ki18n("Iven Wold"), ki18n("KDE 4 changes"), "hour.glass2@yahoo.com" );
	aboutData->addCredit( ki18n("Matteo Merli"), ki18n("qtrans 0.1.1 for KDE 2"), "merlim@libero.it" );
	aboutData->addCredit(ki18n("Frederic Jolliton"), ki18n("Babylon library"), "fjolliton@free.fr");

	KCmdLineArgs::init(argc, argv, aboutData);   //ooo
	KCmdLineArgs::addCmdLineOptions( options );

	KUniqueApplication::addCmdLineOptions();

	if (!KUniqueApplication::start()) {
		//fprintf(stderr, "myAppName is already running!\n");
		fprintf(stderr, "QTrans is already running!\n");
		return 0;
	}

	KUniqueApplication app;
	app.setQuitOnLastWindowClosed(false);
	//app.setStyle("cleanlooks");	//ooo
	//app.setStyle("plastique");	//ooo

/*	QString kde_overrideStyle;
	QString defaultStyle = KStyle::defaultStyle();
	//KConfigGroup pConfig (KGlobal::config(), "General");
	KConfigGroup pConfig (KGlobal::config(), "QTrans");
	QString styleStr = pConfig.readEntry("widgetStyle", defaultStyle);

	QTextStream out(stdout);
	out << "styleStr = " << styleStr;

	if (kde_overrideStyle.isEmpty()) {
		if (styleStr.isEmpty())
			return 0;
		QStyle* sp = QStyleFactory::create( styleStr );
		//QStyle* sp = QStyleFactory::create("plastique");

		if ( !sp && styleStr != defaultStyle) {
			sp = QStyleFactory::create( defaultStyle );
		}
		if ( !sp ) {
			sp = QStyleFactory::create( *(QStyleFactory::keys().begin()) );
		}
		app.setStyle(sp);
	} else {
		app.setStyle(kde_overrideStyle);
	}
*/

	//QString kde_overrideStyle;
	KConfigGroup pConfig (KGlobal::config(), "General");
	QString defaultStyle = KStyle::defaultStyle();
	QString styleStr = pConfig.readEntry("widgetStyle", defaultStyle);

	//KConfigGroup pConfig (KGlobal::config()/*.data()*/, "QTrans");
	//QString styleStr = pConfig.readEntry("widgetStyle", defaultStyle);

	KConfigGroup pConfig2 (KGlobal::config()/*.data()*/, "QTrans");
	QString kde_overrideStyle = pConfig2.readEntry("widgetStyle", defaultStyle);

	//QTextStream out(stdout);
	//out << "defaultStyle = " << defaultStyle << endl;
	//out << "styleStr = " << styleStr << endl;
	//out << "kde_overrideStyle = " << kde_overrideStyle << endl;

	//if (kde_overrideStyle.isEmpty()) {
	if (kde_overrideStyle == "Default") {
		//out << "kde_overrideStyle.isEmpty() " << endl;
		if (styleStr.isEmpty())
			return 0;
		QStyle* sp = QStyleFactory::create( styleStr );
		//QStyle* sp = QStyleFactory::create("plastique");

		if ( !sp && styleStr != defaultStyle) {
			sp = QStyleFactory::create( defaultStyle );
		}
		if ( !sp ) {
			sp = QStyleFactory::create( *(QStyleFactory::keys().begin()) );
		}
		//for (int i = 0; i < fonts.size(); ++i)
		//	cout << fonts.at(i).toLocal8Bit().constData() << endl;
		//for (int i = 0; i < QStyleFactory::keys().size(); ++i)
		//	out << QStyleFactory::keys().at(i).toLocal8Bit().constData() << endl;
		app.setStyle(sp);
	} else {
		//out << "!kde_overrideStyle.isEmpty() " << endl;
		app.setStyle(kde_overrideStyle);
	}

	//app.setStyle(QStyleFactory::create(defaultStyle));
	//app.setStyle(QStyleFactory::create(defaultStyle));
	//app.setStyle(QStyleFactory::create( *(QStyleFactory::keys().end()) ));


	//-- Useless but amazing stuff ;) --
/*	QApplication::setEffectEnabled(Qt::UI_General);
	QApplication::setEffectEnabled(Qt::UI_FadeMenu);
	QApplication::setEffectEnabled(Qt::UI_AnimateCombo);
	QApplication::setEffectEnabled(Qt::UI_FadeTooltip);
*/
	QTrans *qtrans = new QTrans(0, aboutData);

	if (qtrans->DockIcon) {
		//qtrans->trayIcon->show();   //see constructor QTrans::QTrans
		//SystemTray icon(aboutData);
		//icon.show();
		//SystemTray* icon = new SystemTray(qtrans, aboutData);
		//icon->show();
	}
	if (!qtrans->StartMin)
		qtrans->show();
 
	return app.exec();
}


