; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "NmapSI4"
!define PRODUCT_VERSION "0.1"
!define PRODUCT_PUBLISHER "Nmapsi4 Project"
!define PRODUCT_WEB_SITE "http://nmapsi4.netsons.org/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\nmapsi4.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
;!insertmacro MUI_PAGE_WELCOME
; License page
;!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
;!define MUI_FINISHPAGE_RUN "$INSTDIR\nmapsi4.exe"
;!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.txt"
;!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
;!insertmacro MUI_LANGUAGE "French"
;!insertmacro MUI_LANGUAGE "German"
;!insertmacro MUI_LANGUAGE "Italian"
;!insertmacro MUI_LANGUAGE "Polish"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "..\pack\nmapsi4-0.1-win32-setup.exe"
InstallDir "$PROGRAMFILES\Nmapsi4"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "Main" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite on
  File "..\nmapsi4-0.1-win32\QtGui4.dll"
  File "..\nmapsi4-0.1-win32\QtCore4.dll"
  File "..\nmapsi4-0.1-win32\nmapsi4.exe"
  File "..\nmapsi4-0.1-win32\mingwm10.dll"
  File "..\nmapsi4-0.1-win32\TODO.txt"
  File "..\nmapsi4-0.1-win32\README.txt"
  File "..\nmapsi4-0.1-win32\COPYING.txt"
  File "..\nmapsi4-0.1-win32\AUTHORS.txt"
  CreateDirectory "$SMPROGRAMS\NmapSI4"
  CreateShortCut "$SMPROGRAMS\NmapSI4\NmapSI4.lnk" "$INSTDIR\nmapsi4.exe"
  CreateShortCut "$DESKTOP\NmapSI4.lnk" "$INSTDIR\nmapsi4.exe"
SectionEnd

Section "Language" SEC02
  SetOverwrite try
  File "..\nmapsi4-0.1-win32\Language\nmapsi4_de.qm"
  File "..\nmapsi4-0.1-win32\Language\nmapsi4_es.qm"
  File "..\nmapsi4-0.1-win32\Language\nmapsi4_fr.qm"
  File "..\nmapsi4-0.1-win32\Language\nmapsi4_it.qm"
  File "..\nmapsi4-0.1-win32\Language\nmapsi4_pl.qm"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\NmapSI4\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\NmapSI4\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\nmapsi4.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\nmapsi4.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} ""
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} ""
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name)  stato rimosso dal tuo computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Sei sicuro di voler rimuovere $(^Name) e tutti i suoi componenti?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\nmapsi4_pl.qm"
  Delete "$INSTDIR\nmapsi4_NONE.qm"
  Delete "$INSTDIR\nmapsi4_it.qm"
  Delete "$INSTDIR\nmapsi4_fr.qm"
  Delete "$INSTDIR\nmapsi4_es.qm"
  Delete "$INSTDIR\nmapsi4_de.qm"
  Delete "$INSTDIR\AUTHORS.txt"
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\NEWS.txt"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\TODO.txt"
  Delete "$INSTDIR\mingwm10.dll"
  Delete "$INSTDIR\nmapsi4.exe"
  Delete "$INSTDIR\QtCore4.dll"
  Delete "$INSTDIR\QtGui4.dll"

  Delete "$SMPROGRAMS\NmapSI4\Uninstall.lnk"
  Delete "$SMPROGRAMS\NmapSI4\Website.lnk"
  Delete "$DESKTOP\NmapSI4.lnk"
  Delete "$SMPROGRAMS\NmapSI4\NmapSI4.lnk"

  RMDir "$SMPROGRAMS\NmapSI4"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd