
/***************************************************************************
 * EchoHeader.cc -- The EchoHeader Class represents
 *                                                                         *
 ***********************IMPORTANT NMAP LICENSE TERMS************************
 *                                                                         *
 * The Nmap Security Scanner is (C) 1996-2010 Insecure.Com LLC. Nmap is    *
 * also a registered trademark of Insecure.Com LLC.  This program is free  *
 * software; you may redistribute and/or modify it under the terms of the  *
 * GNU General Public License as published by the Free Software            *
 * Foundation; Version 2 with the clarifications and exceptions described  *
 * below.  This guarantees your right to use, modify, and redistribute     *
 * this software under certain conditions.  If you wish to embed Nmap      *
 * technology into proprietary software, we sell alternative licenses      *
 * (contact sales@insecure.com).  Dozens of software vendors already       *
 * license Nmap technology such as host discovery, port scanning, OS       *
 * detection, and version detection.                                       *
 *                                                                         *
 * Note that the GPL places important restrictions on "derived works", yet *
 * it does not provide a detailed definition of that term.  To avoid       *
 * misunderstandings, we consider an application to constitute a           *
 * "derivative work" for the purpose of this license if it does any of the *
 * following:                                                              *
 * o Integrates source code from Nmap                                      *
 * o Reads or includes Nmap copyrighted data files, such as                *
 *   nmap-os-db or nmap-service-probes.                                    *
 * o Executes Nmap and parses the results (as opposed to typical shell or  *
 *   execution-menu apps, which simply display raw Nmap output and so are  *
 *   not derivative works.)                                                *
 * o Integrates/includes/aggregates Nmap into a proprietary executable     *
 *   installer, such as those produced by InstallShield.                   *
 * o Links to a library or executes a program that does any of the above   *
 *                                                                         *
 * The term "Nmap" should be taken to also include any portions or derived *
 * works of Nmap.  This list is not exclusive, but is meant to clarify our *
 * interpretation of derived works with some common examples.  Our         *
 * interpretation applies only to Nmap--we don't speak for other people's  *
 * GPL works.                                                              *
 *                                                                         *
 * If you have any questions about the GPL licensing restrictions on using *
 * Nmap in non-GPL works, we would be happy to help.  As mentioned above,  *
 * we also offer alternative license to integrate Nmap into proprietary    *
 * applications and appliances.  These contracts have been sold to dozens  *
 * of software vendors, and generally include a perpetual license as well  *
 * as providing for priority support and updates as well as helping to     *
 * fund the continued development of Nmap technology.  Please email        *
 * sales@insecure.com for further information.                             *
 *                                                                         *
 * As a special exception to the GPL terms, Insecure.Com LLC grants        *
 * permission to link the code of this program with any version of the     *
 * OpenSSL library which is distributed under a license identical to that  *
 * listed in the included COPYING.OpenSSL file, and distribute linked      *
 * combinations including the two. You must obey the GNU GPL in all        *
 * respects for all of the code used other than OpenSSL.  If you modify    *
 * this file, you may extend this exception to your version of the file,   *
 * but you are not obligated to do so.                                     *
 *                                                                         *
 * If you received these files with a written license agreement or         *
 * contract stating terms other than the terms above, then that            *
 * alternative license agreement takes precedence over these comments.     *
 *                                                                         *
 * Source is provided to this software because we believe users have a     *
 * right to know exactly what a program is going to do before they run it. *
 * This also allows you to audit the software for security holes (none     *
 * have been found so far).                                                *
 *                                                                         *
 * Source code also allows you to port Nmap to new platforms, fix bugs,    *
 * and add new features.  You are highly encouraged to send your changes   *
 * to nmap-dev@insecure.org for possible incorporation into the main       *
 * distribution.  By sending these changes to Fyodor or one of the         *
 * Insecure.Org development mailing lists, it is assumed that you are      *
 * offering the Nmap Project (Insecure.Com LLC) the unlimited,             *
 * non-exclusive right to reuse, modify, and relicense the code.  Nmap     *
 * will always be available Open Source, but this is important because the *
 * inability to relicense code has caused devastating problems for other   *
 * Free Software projects (such as KDE and NASM).  We also occasionally    *
 * relicense the code to third parties as discussed above.  If you wish to *
 * specify special license conditions of your contributions, just say so   *
 * when you send them.                                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License v2.0 for more details at                         *
 * http://www.gnu.org/licenses/gpl-2.0.html , or in the COPYING file       *
 * included with Nmap.                                                     *
 *                                                                         *
 ***************************************************************************/

#include "EchoHeader.h"
#include "nping.h"
#include "common.h"
#include "utils_net.h"



/*****************************************************************************/
/** CONSTRUCTORS, ETC                                                        */ 
/*****************************************************************************/
EchoHeader::EchoHeader(){

    memset( &h, 0, sizeof(struct my_echo_hdr));
    length=0; /* TODO: */

    this->setVersion(ECHO_CURRENT_PROTO_VER);

} /* End of EchoHeader constructor */



EchoHeader::~EchoHeader(){

} /* End of EchoHeader destructor */


/** @warning This method is essential for the superclass getBinaryBuffer()
 *  method to work. Do NOT change a thing unless you know what you're doing  */
u8 * EchoHeader::getBufferPointer(){

  return (u8*)(&h);

} /* End of getBufferPointer() */








/*****************************************************************************/
/** COMMON HEADER FIELDS                                                     */ 
/*****************************************************************************/
/** Sets Version.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setVersion(u8 val){    

    this->h.echo_ver=val;
           
    return OP_SUCCESS;   
    
} /* End of setVersion() */  


/** Returns value of attribute h.echo_ver */    
u8 EchoHeader::getVersion(){

    return this->h.echo_ver;    
    
} /* End of getVersion() */



/** Sets Operation.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setOperation(u8 code){    

  this->h.echo_op=code;
    
  switch( code ){

    case ECHO_OP_HELLO:
    case ECHO_OP_HELLO_RESPONSE:
         this->echo_ipver = &(h.echo_res[4]);
         this->echo_pip = h.data + OFFSET_HELLO_PARTNER_IP;
         this->echo_hello_res = h.data + OFFSET_HELLO_RESERVED;
         this->echo_sum = h.data + OFFSET_HELLO_CHECKSUM;
    break;
    
    case ECHO_OP_SPECS:
    case ECHO_OP_READY:
    case ECHO_OP_ECHO:
    case ECHO_OP_QUIT:
    break;
  }
  
  return OP_SUCCESS;   
    
} /* End of setOperation() */  


/** Returns value of attribute h.echo_op */    
u8 EchoHeader::getOperation(){

    return this->h.echo_op;    
    
} /* End of getOperation() */



/** Sets TotalLength.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setTotalLength(u16 val){    

    this->h.echo_tlen= htons(val);
           
    return OP_SUCCESS;   
    
} /* End of setTotalLength() */


/** Sets TotalLength.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setTotalLength(){    

  switch( this->getOperation() ){

    case ECHO_OP_HELLO:
    case ECHO_OP_HELLO_RESPONSE:
         this->setTotalLength(15*4);
    break;
    
    case ECHO_OP_SPECS:
    case ECHO_OP_READY:
    case ECHO_OP_ECHO:
    case ECHO_OP_QUIT:
        outFatal(QT_3, "setTotalLength(): Operation not yet implemented");
    break;
    
  }
           
    return OP_SUCCESS;   
    
} /* End of setTotalLength() */


/** Returns value of attribute h.echo_tlen */    
u16 EchoHeader::getTotalLength(){

    return ntohs(this->h.echo_tlen);    
    
} /* End of getTotalLength() */



/** Sets SequenceNumber.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setSequenceNumber(u32 val){    

    this->h.echo_seq=htonl(val);
           
    return OP_SUCCESS;   
    
} /* End of setSequenceNumber() */  


/** Returns value of attribute h.echo_seq */    
u32 EchoHeader::getSequenceNumber(){

    return ntohl(this->h.echo_seq);    
    
} /* End of getSequenceNumber() */



/** Sets Reserved.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setReserved(u8 * val){    

    if(val==NULL)
        return OP_FAILURE;
        
    memcpy(this->h.echo_res, val, 4);
           
    return OP_SUCCESS;   
    
} /* End of setReserved() */  


/** Returns value of attribute h.echo_res */    
u8 * EchoHeader::getReserved(){

    return this->h.echo_res;    
    
} /* End of getReserved() */


/** Sets Checksum.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setChecksum(){    
    
    /* TODO: Compute checksum here */
           
    return OP_SUCCESS;   
    
} /* End of setChecksum() */  


/** Returns value of attribute echo_sum */    
u8 * EchoHeader::getChecksum(){

    return this->echo_sum;    
    
} /* End of getChecksum() */




/** Sets HelloIPVersion.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setHelloIPVersion(u8 val){    

    if(this->echo_ipver==NULL)
        outFatal(QT_3,"setHelloIPVersion(): EchoHeader::echo_ipver is NULL");

    *(this->echo_ipver)=val;
           
    return OP_SUCCESS;   
    
} /* End of setHelloIPVersion() */  


/** Returns value of attribute echo_ipver */    
u8 EchoHeader::getHelloIPVersion(){

    if(this->echo_ipver==NULL)
        outFatal(QT_3,"getHelloIPVersion(): EchoHeader::echo_ipver is NULL");

    return (u8)(*(this->echo_ipver));    
    
} /* End of getHelloIPVersion() */










/*****************************************************************************/
/** HELLO RELATED FIELDS                                                     */ 
/*****************************************************************************/

/** Sets HelloPartnerIP.
 *  @return OP_SUCCESS on success and OP_FAILURE in case of error.           */    
int EchoHeader::setHelloPartnerIP(u8 * val){

    if(val==NULL)
        outFatal(QT_3,"setHelloPartnerIP(): NULL value supplied");

    if(this->echo_pip==NULL)
        outFatal(QT_3,"setHelloPartnerIP(): EchoHeader::echo_pip is NULL");

    this->setHelloIPVersion(6);
    memcpy(this->echo_pip, val, 16);
           
    return OP_SUCCESS;   
    
} /* End of setHelloPartnerIP() */  


int EchoHeader::setHelloPartnerIP(u32 val){    

    if(this->echo_pip==NULL)
        outFatal(QT_3,"setHelloPartnerIP(): EchoHeader::echo_pip is NULL");

    this->setHelloIPVersion(4);
    memset(this->echo_pip, 0, 16);  /* Zero the entire field           */
    memcpy(this->echo_pip, &val, 4); /* Store the supplied IPv4 address */
           
    return OP_SUCCESS;   
    
} /* End of setHelloPartnerIP() */ 


/** Returns value of attribute echo_pip */    
u8 * EchoHeader::getHelloPartnerIP(){

    return this->echo_pip;    
    
} /* End of getHelloPartnerIP() */


/** Returns value of attribute echo_pip */    
u32 EchoHeader::getHelloPartnerIPv4(){

    u32 *ip = (u32 *)this->echo_pip;

    if(this->echo_pip==NULL)
        outFatal(QT_3,"getHelloPartnerIPv4(): EchoHeader::echo_pip is NULL");

    return *ip;    
    
} /* End of getHelloPartnerIP() */




/** Used for testing */
int EchoHeader::printPacket(){


  printf("VERSION:    %d\n", this->getVersion() );
  printf("OPERATION:  %d\n", this->getOperation() );
  printf("TOTAL LEN:  %d\n", this->getTotalLength() );
  printf("SEQ NUMBER: %08X\n", this->getSequenceNumber() );

  switch( this->getOperation() ){

    case ECHO_OP_HELLO:
    case ECHO_OP_HELLO_RESPONSE:
         if(this->echo_ipver)
            printf("IP VERSION: %d", this->getHelloIPVersion() );
         else
            printf("IP VERSION: NULL!");

         if(this->echo_pip)
            printf("PARTNER IP: %s", IPtoa(this->getHelloPartnerIPv4()) );                     
         else
            printf("PARTNER IP: NULL!");

         this->echo_hello_res = h.data + OFFSET_HELLO_RESERVED;
         this->echo_sum = h.data + OFFSET_HELLO_CHECKSUM;
    break;
    
    case ECHO_OP_SPECS:
    case ECHO_OP_READY:
    case ECHO_OP_ECHO:
    case ECHO_OP_QUIT:
    break;

    if(this->echo_sum){
        printf("CHECKSUM:   ");    
        for(int i=0; i<16; i++)
            printf("%02x", this->echo_sum[i]);
        printf("\n");
    }else
        printf("CHECKSUM:   NULL!");    
    
  }

  return OP_SUCCESS;

} /* End of printPacket() */
