/* -*- Mode: C; c-basic-offset:4 ; -*- */
/* 
 *   $Id: iotestsome.c,v 1.2 2003/09/09 15:49:26 gropp Exp $    
 *
 *   Copyright (C) 2003 University of Chicago. 
 *   See COPYRIGHT notice in top-level directory.
 */

#include "mpioimpl.h"

#ifdef HAVE_WEAK_SYMBOLS

#if defined(HAVE_PRAGMA_WEAK)
#pragma weak MPIO_Testsome = PMPIO_Testsome
#elif defined(HAVE_PRAGMA_HP_SEC_DEF)
#pragma _HP_SECONDARY_DEF PMPIO_Testsome MPIO_Testsome
#elif defined(HAVE_PRAGMA_CRI_DUP)
#pragma _CRI duplicate MPIO_Testsome as PMPIO_Testsome
/* end of weak pragmas */
#endif

/* Include mapping from MPI->PMPI */
#define MPIO_BUILD_PROFILING
#include "mpioprof.h"
#endif

/*
  This is a temporary function until we switch to using MPI-2's generalized
  requests.
*/

int MPIO_Testsome(int count, MPIO_Request requests[], int *outcount,
		  int indices[], MPI_Status *statuses)
{
    int i, err; 
    int flag;

    if (count == 1) {
	err = MPIO_Test( requests, &flag, statuses );
	if (!err) {
	    if (flag) {
		indices[0] = 0;
		*outcount = 1;
	    }
	    else {
		*outcount = 0;
	    }
	}
	return err;
    }

    /* Check for no active requests */
    for (i=0; i<count; i++) {
	if (requests[i] != MPIO_REQUEST_NULL) {
	    break;
	}
    }
    if (i == count) {
	*outcount = MPI_UNDEFINED;
	return MPI_SUCCESS;
    }

    err = MPI_SUCCESS;
    *outcount = 0;
    for (i=0; i<count; i++) {
      if (requests[i] != MPIO_REQUEST_NULL) {
	err = MPIO_Test( &requests[i], &flag, statuses );
	if (flag) {
	  if (!err) {
	      indices[0] = i;
	      indices++;
	      statuses++;
	      *outcount = *outcount + 1;
	  }
	}
      }
    }

    return err;
}
