/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.ColorAlpha;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class ColorNameMap {
    private static HashMap colormap = null;

    public static void initMapFromRGBtxt(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            System.err.println("ColorNameMap: Could NOT locate " + string + " in CLASSPATH.  Exiting...!");
            System.exit(1);
        }
        colormap = new HashMap(800);
        try {
            String string2;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 20480);
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                ColorAlpha colorAlpha = new ColorAlpha(n, n2, n3);
                String string3 = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + " " + stringTokenizer.nextToken();
                }
                colormap.put(string3, colorAlpha);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public static ColorAlpha getColorAlpha(String string) {
        int n = string.indexOf(58);
        String string2 = n != -1 ? string.substring(0, n) : string;
        ColorAlpha colorAlpha = (ColorAlpha)colormap.get(string2);
        if (colorAlpha == null) {
            System.err.println("ColorNameMap: Could NOT locate colorname " + string2 + " in default rgb.txt, i.e. " + "jumpshot.colors");
        }
        return colorAlpha;
    }

    public static String getString() {
        StringBuffer stringBuffer = new StringBuffer("ColorNameMap : \n");
        int n = 0;
        Iterator iterator = colormap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(++n + ", " + (String)entry.getKey() + " -> " + (ColorAlpha)entry.getValue() + "\n");
        }
        return stringBuffer.toString();
    }

    public static final void main(String[] stringArray) {
        String string = "jumpshot.colors";
        ColorNameMap.initMapFromRGBtxt(string);
        System.out.println("navy blue is " + ColorNameMap.getColorAlpha("navy blue"));
        System.out.println("green:dimple3 is " + ColorNameMap.getColorAlpha("green:dimple3"));
    }
}

