/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository;

import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;

public class DefaultNameGenerator
implements NameGenerator {
    private ContentLocation location;
    private String defaultNameHint;
    private String defaultSuffix;

    public DefaultNameGenerator(ContentLocation location) {
        this(location, "file", null);
    }

    public DefaultNameGenerator(ContentLocation location, String defaultNameHint) {
        if (location == null) {
            throw new NullPointerException();
        }
        if (defaultNameHint == null) {
            throw new NullPointerException();
        }
        this.location = location;
        int pos = defaultNameHint.lastIndexOf(46);
        if (this.defaultSuffix == null && pos > 0) {
            if (pos < defaultNameHint.length() - 1) {
                this.defaultNameHint = defaultNameHint.substring(0, pos);
                this.defaultSuffix = defaultNameHint.substring(pos + 1);
            } else {
                this.defaultNameHint = defaultNameHint.substring(0, pos);
                this.defaultSuffix = null;
            }
        } else {
            this.defaultNameHint = defaultNameHint;
            this.defaultSuffix = null;
        }
    }

    public DefaultNameGenerator(ContentLocation location, String defaultNameHint, String defaultSuffix) {
        if (location == null) {
            throw new NullPointerException();
        }
        if (defaultNameHint == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.defaultNameHint = defaultNameHint;
        this.defaultSuffix = defaultSuffix;
    }

    public String generateName(String nameHint, String mimeType) throws ContentIOException {
        String name = nameHint != null ? nameHint : this.defaultNameHint;
        String suffix = this.defaultSuffix != null ? this.defaultSuffix : this.getSuffixForType(mimeType, this.location);
        String firstFileName = name + '.' + suffix;
        if (!this.location.exists(firstFileName)) {
            return firstFileName;
        }
        int counter = 0;
        while (true) {
            if (counter < 0) {
                throw new ContentIOException();
            }
            String filename = name + counter + '.' + suffix;
            if (!this.location.exists(filename)) {
                return filename;
            }
            ++counter;
        }
    }

    private String getSuffixForType(String mimeType, ContentLocation location) {
        Repository repository = location.getRepository();
        MimeRegistry mimeRegistry = repository.getMimeRegistry();
        return mimeRegistry.getSuffix(mimeType);
    }
}

