/*
 * xmlformat - registration of xml object formats 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#ifndef XMLFORMAT_NOTE_H
#define XMLFORMAT_NOTE_H

#include "xmlformat-common.h"
#include "xmlformat-calendar.h"

#define XMLFORMAT_NOTE_ROOT				"note"
#define XMLFORMAT_NOTE_VERSION				"version"

// Attach
#define XMLFORMAT_NOTE_ATTACH				"Attach"
#define XMLFORMAT_NOTE_ATTACH_CONTENT			XMLFORMAT_CALENDAR_ATTACHMENT_CONTENT
#define XMLFORMAT_NOTE_ATTACH_VALUE			XMLFORMAT_CALENDAR_ATTACHMENT_VALUE
#define XMLFORMAT_NOTE_ATTACH_VALUE_URI			XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI	
#define XMLFORMAT_NOTE_ATTACH_VALUE_BINARY		XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY
#define XMLFORMAT_NOTE_ATTACH_FORMATTYPE		XMLFORMAT_CALENDAR_ATTACHMENT_FORMATTYPE
#define XMLFORMAT_NOTE_ATTACH_ENCODING			XMLFORMAT_CALENDAR_ATTACHMENT_ENCODING

// Attendee
#define XMLFORMAT_NOTE_ATTENDEE				"Attendee"
#define XMLFORMAT_NOTE_ATTENDEE_CONTENT			XMLFORMAT_CALENDAR_ATTENDEE_CONTENT
#define XMLFORMAT_NOTE_ATTENDEE_CUTYPE			XMLFORMAT_CALENDAR_ATTENDEE_CUTYPE
#define XMLFORMAT_NOTE_ATTENDEE_CUTYPE_INDIVIDUAL	XMLFORMAT_CALENDAR_CALENDARUSERTYPE_INDIVIDUAL
#define XMLFORMAT_NOTE_ATTENDEE_CUTYPE_GROUP		XMLFORMAT_CALENDAR_CALENDARUSERTYPE_GROUP
#define XMLFORMAT_NOTE_ATTENDEE_CUTYPE_RESOURCE		XMLFORMAT_CALENDAR_CALENDARUSERTYPE_RESOURCE
#define XMLFORMAT_NOTE_ATTENDEE_CUTYPE_ROOM		XMLFORMAT_CALENDAR_CALENDARUSERTYPE_ROOM	
#define XMLFORMAT_NOTE_ATTENDEE_CUTYPE_UNKNOWN		XMLFORMAT_CALENDAR_CALENDARUSERTYPE_UNKNOWN
#define XMLFORMAT_NOTE_ATTENDEE_MEMBER			XMLFORMAT_CALENDAR_ATTENDEE_MEMBER
#define XMLFORMAT_NOTE_ATTENDEE_ROLE			XMLFORMAT_CALENDAR_ATTENDEE_ROLE
#define XMLFORMAT_NOTE_ATTENDEE_ROLE_NEEDSACTION	XMLFORMAT_CALENDAR_ROLETYPE_NEEDSACTION
#define XMLFORMAT_NOTE_ATTENDEE_ROLE_ACCEPTED		XMLFORMAT_CALENDAR_ROLETYPE_ACCEPTED
#define XMLFORMAT_NOTE_ATTENDEE_ROLE_DECLINED		XMLFORMAT_CALENDAR_ROLETYPE_DECLINED
#define XMLFORMAT_NOTE_ATTENDEE_ROLE_TENTATIVE		XMLFORMAT_CALENDAR_ROLETYPE_TENTATIVE
#define XMLFORMAT_NOTE_ATTENDEE_ROLE_DELEGATED		XMLFORMAT_CALENDAR_ROLETYPE_DELEGATED
#define XMLFORMAT_NOTE_ATTENDEE_PARTSTAT		XMLFORMAT_CALENDAR_ATTENDEE_PARTSTAT
#define XMLFORMAT_NOTE_ATTENDEE_RSVP			XMLFORMAT_CALENDAR_ATTENDEE_RSVP
#define XMLFORMAT_NOTE_ATTENDEE_DELEGATEDFROM		XMLFORMAT_CALENDAR_ATTENDEE_DELEGATEDFROM
#define XMLFORMAT_NOTE_ATTENDEE_SENTBY			XMLFORMAT_CALENDAR_ATTENDEE_SENTBY
#define XMLFORMAT_NOTE_ATTENDEE_COMMONNAME		XMLFORMAT_CALENDAR_ATTENDEE_COMMONNAME
#define XMLFORMAT_NOTE_ATTENDEE_DIRECTORY		XMLFORMAT_CALENDAR_ATTENDEE_DIRECTORY
#define XMLFORMAT_NOTE_ATTENDEE_LANGUAGE		XMLFORMAT_CALENDAR_ATTENDEE_LANGUAGE

// Categories
#define XMLFORMAT_NOTE_CATEGORIES			"Categories"
#define XMLFORMAT_NOTE_CATEGORIES_CATEGORY		XMLFORMAT_COMMON_CATEGORIES_CATEGORY

// Class
#define XMLFORMAT_NOTE_CLASS				"Class"
#define XMLFORMAT_NOTE_CLASS_CONTENT			XMLFORMAT_COMMON_CLASS_CONTENT
#define XMLFORMAT_NOTE_CLASS_CONTENT_PUBLIC		XMLFORMAT_COMMON_CLASS_CONTENT_PUBLIC
#define XMLFORMAT_NOTE_CLASS_CONTENT_PRIVATE		XMLFORMAT_COMMON_CLASS_CONTENT_PRIVATE
#define XMLFORMAT_NOTE_CLASS_CONTENT_CONFIDENTIAL	XMLFORMAT_COMMON_CLASS_CONTENT_CONFIDENTIAL

// Comment
#define XMLFORMAT_NOTE_COMMENT				"Comment"
#define XMLFORMAT_NOTE_COMMENT_CONTENT			XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_NOTE_COMMENT_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_NOTE_COMMENT_LANGUAGE			XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// Contact
#define XMLFORMAT_NOTE_CONTACT				"Contact"
#define XMLFORMAT_NOTE_CONTACT_CONTENT			XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_NOTE_CONTACT_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_NOTE_CONTACT_LANGUAGE			XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// Created
#define XMLFORMAT_NOTE_CREATED				"Created"
#define XMLFORMAT_NOTE_CREATED_CONTENT			XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_NOTE_CREATED_VALUE			XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_NOTE_CREATED_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_NOTE_CREATED_VALUE_DATETIME		XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_NOTE_CREATED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// DateCalendarCreated
#define XMLFORMAT_NOTE_DATECALENDARCREATED		"DateCalendarCreated"
#define XMLFORMAT_NOTE_DATECALENDARCREATED_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_NOTE_DATECALENDARCREATED_VALUE	XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_NOTE_DATECALENDARCREATED_VALUE_DATE	XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_NOTE_DATECALENDARCREATED_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_NOTE_DATECALENDARCREATED_TIMEZONEID	XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// DateStarted
#define XMLFORMAT_NOTE_DATESTARTED			"DateStarted"
#define XMLFORMAT_NOTE_DATESTARTED_CONTENT		XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_NOTE_DATESTARTED_VALUE		XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_NOTE_DATESTARTED_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_NOTE_DATESTARTED_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_NOTE_DATESTARTED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// Description
#define XMLFORMAT_NOTE_DESCRIPTION			"Description"
#define XMLFORMAT_NOTE_DESCRIPTION_CONTENT		XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_NOTE_DESCRIPTION_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_NOTE_DESCRIPTION_LANGUAGE		XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// ExceptionDateTime
#define XMLFORMAT_NOTE_EXCEPTIONDATETIME		"ExceptionDateTime"
#define XMLFORMAT_NOTE_EXCEPTIONDATETIME_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_NOTE_EXCEPTIONDATETIME_VALUE		XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_NOTE_EXCEPTIONDATETIME_VALUE_DATE	XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_NOTE_EXCEPTIONDATETIME_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_NOTE_EXCEPTIONDATETIME_TIMEZONEID	XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// ExceptionRule
#define XMLFORMAT_NOTE_EXCEPTIONRULE			"ExceptionRule"
#define XMLFORMAT_NOTE_EXCEPTIONRULE_FREQUENCY		XMLFORMAT_CALENDAR_RECURRENCERULE_FREQUENCY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_FREQUENCY_DAILY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_DAILY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_FREQUENCY_WEEKLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_WEEKLY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_FREQUENCY_MONTHLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_MONTHLY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_FREQUENCY_YEARLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_YEARLY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_UNTIL		XMLFORMAT_CALENDAR_RECURRENCERULE_UNTIL
#define XMLFORMAT_NOTE_EXCEPTIONRULE_COUNT		XMLFORMAT_CALENDAR_RECURRENCERULE_COUNT
#define XMLFORMAT_NOTE_EXCEPTIONRULE_INTERVAL		XMLFORMAT_CALENDAR_RECURRENCERULE_INTERVAL
#define XMLFORMAT_NOTE_EXCEPTIONRULE_BYDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYDAY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_BYMONTHDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTHDAY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_BYYEARDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYYEARDAY
#define XMLFORMAT_NOTE_EXCEPTIONRULE_BYMONTH		XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTH
#define XMLFORMAT_NOTE_EXCEPTIONRULE_TIMEZONEID		XMLFORMAT_CALENDAR_RECURRENCERULE_TIMEZONEID
#define XMLFORMAT_NOTE_EXCEPTIONRULE_TZCOMPONENT	XMLFORMAT_CALENDAR_RECURRENCERULE_TZCOMPONENT

// LastModified
#define XMLFORMAT_NOTE_LASTMODIFIED			"LastModified"
#define XMLFORMAT_NOTE_LASTMODIFIED_CONTENT		XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_NOTE_LASTMODIFIED_VALUE		XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_NOTE_LASTMODIFIED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// Method
#define XMLFORMAT_NOTE_METHOD				"Method"
#define XMLFORMAT_NOTE_METHOD_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Organizer
#define XMLFORMAT_NOTE_ORGANIZER			"Organizer"
#define XMLFORMAT_NOTE_ORGANIZER_CONTENT		XMLFORMAT_CALENDAR_ORGANIZER_CONTENT
#define XMLFORMAT_NOTE_ORGANIZER_COMMONNAME		XMLFORMAT_CALENDAR_ORGANIZER_COMMONNAME	
#define XMLFORMAT_NOTE_ORGANIZER_DIRECTORY		XMLFORMAT_CALENDAR_ORGANIZER_DIRECTORY
#define XMLFORMAT_NOTE_ORGANIZER_SENTBY			XMLFORMAT_CALENDAR_ORGANIZER_SENTBY
#define XMLFORMAT_NOTE_ORGANIZER_LANGUAGE		XMLFORMAT_CALENDAR_ORGANIZER_LANGUAGE

// ProductID
#define XMLFORMAT_NOTE_PRODUCTID			"ProductID"
#define XMLFORMAT_NOTE_PRODUCTID_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// RecurrenceId
#define XMLFORMAT_NOTE_RECURRENCEID			"RecurrenceId"
#define XMLFORMAT_NOTE_RECURRENCEID_CONTENT		XMLFORMAT_CALENDAR_RECURRENCEID_CONTENT	
#define XMLFORMAT_NOTE_RECURRENCEID_TIMEZONEID		XMLFORMAT_CALENDAR_RECURRENCEID_TIMEZONEID
#define XMLFORMAT_NOTE_RECURRENCEID_RANGE		XMLFORMAT_CALENDAR_RECURRENCEID_RANGE
#define XMLFORMAT_NOTE_RECURRENCEID_RANGE_THISANDPRIOR	XMLFORMAT_CALENDAR_RECURRENCEID_RANGE_THISANDPRIOR
#define XMLFORMAT_NOTE_RECURRENCEID_RANGE_THISANDFUTURE	XMLFORMAT_CALENDAR_RECURRENCEID_RANGE_THISANDFUTURE
#define XMLFORMAT_NOTE_RECURRENCEID_VALUE		XMLFORMAT_CALENDAR_RECURRENCEID_VALUE
#define XMLFORMAT_NOTE_RECURRENCEID_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_NOTE_RECURRENCEID_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME

// Related
#define XMLFORMAT_NOTE_RELATED				"Related"
#define XMLFORMAT_NOTE_RELATED_CONTENT			XMLFORMAT_CALENDAR_RELATEDTO_CONTENT
#define XMLFORMAT_NOTE_RELATED_TIMEZONEID		XMLFORMAT_CALENDAR_RELATEDTO_TIMEZONEID	
#define XMLFORMAT_NOTE_RELATED_RELATIONSHIPTYPE		XMLFORMAT_CALENDAR_RELATEDTO_RELATIONSHIPTYPE
#define XMLFORMAT_NOTE_RELATED_RELATIONSHIPTYPE_PARENT	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_PARENT
#define XMLFORMAT_NOTE_RELATED_RELATIONSHIPTYPE_CHILD	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_CHILD
#define XMLFORMAT_NOTE_RELATED_RELATIONSHIPTYPE_SIBLING	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_SIBLING

// RecurrenceRule
#define XMLFORMAT_NOTE_RECURRENCERULE			"RecurrenceRule"
#define XMLFORMAT_NOTE_RECURRENCERULE_FREQUENCY		XMLFORMAT_CALENDAR_RECURRENCERULE_FREQUENCY
#define XMLFORMAT_NOTE_RECURRENCERULE_FREQUENCY_DAILY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_DAILY
#define XMLFORMAT_NOTE_RECURRENCERULE_FREQUENCY_WEEKLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_WEEKLY
#define XMLFORMAT_NOTE_RECURRENCERULE_FREQUENCY_MONTHLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_MONTHLY
#define XMLFORMAT_NOTE_RECURRENCERULE_FREQUENCY_YEARLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_YEARLY
#define XMLFORMAT_NOTE_RECURRENCERULE_UNTIL		XMLFORMAT_CALENDAR_RECURRENCERULE_UNTIL
#define XMLFORMAT_NOTE_RECURRENCERULE_COUNT		XMLFORMAT_CALENDAR_RECURRENCERULE_COUNT
#define XMLFORMAT_NOTE_RECURRENCERULE_INTERVAL		XMLFORMAT_CALENDAR_RECURRENCERULE_INTERVAL
#define XMLFORMAT_NOTE_RECURRENCERULE_BYDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYDAY
#define XMLFORMAT_NOTE_RECURRENCERULE_BYMONTHDAY	XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTHDAY
#define XMLFORMAT_NOTE_RECURRENCERULE_BYYEARDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYYEARDAY
#define XMLFORMAT_NOTE_RECURRENCERULE_BYMONTH		XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTH
#define XMLFORMAT_NOTE_RECURRENCERULE_TIMEZONEID	XMLFORMAT_CALENDAR_RECURRENCERULE_TIMEZONEID
#define XMLFORMAT_NOTE_RECURRENCERULE_TZCOMPONENT	XMLFORMAT_CALENDAR_RECURRENCERULE_TZCOMPONENT

// RStatus
#define XMLFORMAT_NOTE_RSTATUS				"RStatus"
#define XMLFORMAT_NOTE_RSTATUS_STATUSCODE		XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSCODE
#define XMLFORMAT_NOTE_RSTATUS_STATUSDESCRIPTION	XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSDESCRIPTION
#define XMLFORMAT_NOTE_RSTATUS_EXCEPTIONDATA		XMLFORMAT_CALENDAR_REQUESTSTATUS_EXCEPTIONDATA
#define XMLFORMAT_NOTE_RSTATUS_TIMEZONEID		XMLFORMAT_CALENDAR_REQUESTSTATUS_TIMEZONEID
#define XMLFORMAT_NOTE_RSTATUS_RELATIONSHIPTYPE		XMLFORMAT_CALENDAR_REQUESTSTATUS_RELATIONSHIPTYPE
#define XMLFORMAT_NOTE_RSTATUS_RELATIONSHIPTYPE_PARENT	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_PARENT
#define XMLFORMAT_NOTE_RSTATUS_RELATIONSHIPTYPE_CHILD	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_CHILD
#define XMLFORMAT_NOTE_RSTATUS_RELATIONSHIPTYPE_SIBLING	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_SIBLING

// Sequence
#define XMLFORMAT_NOTE_SEQUENCE				"Sequence"
#define XMLFORMAT_NOTE_SEQUENCE_CONTENT			XMLFORMAT_CALENDAR_INTEGERCONTENT_CONTENT

// Status
#define XMLFORMAT_NOTE_STATUS				"Status"
#define XMLFORMAT_NOTE_STATUS_CONTENT			XMLFORMAT_CALENDAR_STATUS_CONTENT
#define XMLFORMAT_NOTE_STATUS_CONTENT_TENTATIVE		XMLFORMAT_CALENDAR_STATUS_CONTENT_TENTATIVE
#define XMLFORMAT_NOTE_STATUS_CONTENT_CONFIRMED		XMLFORMAT_CALENDAR_STATUS_CONTENT_CONFIRMED
#define XMLFORMAT_NOTE_STATUS_CONTENT_CANCELLED		XMLFORMAT_CALENDAR_STATUS_CONTENT_CANCELLED

// Summary
#define XMLFORMAT_NOTE_SUMMARY				"Summary"
#define XMLFORMAT_NOTE_SUMMARY_CONTENT			XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_NOTE_SUMMARY_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_NOTE_SUMMARY_LANGUAGE			XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// Uid
#define XMLFORMAT_NOTE_UID				"Uid"
#define XMLFORMAT_NOTE_UID_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Url
#define XMLFORMAT_NOTE_URL				"Url"
#define XMLFORMAT_NOTE_URL_CONTENT			XMLFORMAT_CALENDAR_URLCONTENT_CONTENT

#endif /* XMLFORMAT_NOTE_H */
