/* testdeque.c generated by valac, the Vala compiler
 * generated from testdeque.vala, do not modify */

/* testdeque.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_QUEUE_TESTS (queue_tests_get_type ())
#define QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUEUE_TESTS, QueueTests))
#define QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUEUE_TESTS, QueueTestsClass))
#define IS_QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUEUE_TESTS))
#define IS_QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUEUE_TESTS))
#define QUEUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUEUE_TESTS, QueueTestsClass))

typedef struct _QueueTests QueueTests;
typedef struct _QueueTestsClass QueueTestsClass;
typedef struct _QueueTestsPrivate QueueTestsPrivate;

#define TYPE_DEQUE_TESTS (deque_tests_get_type ())
#define DEQUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEQUE_TESTS, DequeTests))
#define DEQUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEQUE_TESTS, DequeTestsClass))
#define IS_DEQUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEQUE_TESTS))
#define IS_DEQUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEQUE_TESTS))
#define DEQUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEQUE_TESTS, DequeTestsClass))

typedef struct _DequeTests DequeTests;
typedef struct _DequeTestsClass DequeTestsClass;
typedef struct _DequeTestsPrivate DequeTestsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _QueueTests {
	CollectionTests parent_instance;
	QueueTestsPrivate * priv;
};

struct _QueueTestsClass {
	CollectionTestsClass parent_class;
};

struct _DequeTests {
	QueueTests parent_instance;
	DequeTestsPrivate * priv;
};

struct _DequeTestsClass {
	QueueTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer deque_tests_parent_class = NULL;

GType gee_test_case_get_type (void);
GType collection_tests_get_type (void);
GType queue_tests_get_type (void);
GType deque_tests_get_type (void);
enum  {
	DEQUE_TESTS_DUMMY_PROPERTY
};
QueueTests* queue_tests_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void deque_tests_test_queue_use (DequeTests* self);
static void _deque_tests_test_queue_use_gee_test_case_test_method (gpointer self);
void deque_tests_test_stack_use (DequeTests* self);
static void _deque_tests_test_stack_use_gee_test_case_test_method (gpointer self);
void deque_tests_test_reversed_stack_use (DequeTests* self);
static void _deque_tests_test_reversed_stack_use_gee_test_case_test_method (gpointer self);
DequeTests* deque_tests_construct (GType object_type, const char* name);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _deque_tests_test_queue_use_gee_test_case_test_method (gpointer self) {
	deque_tests_test_queue_use (self);
}


static void _deque_tests_test_stack_use_gee_test_case_test_method (gpointer self) {
	deque_tests_test_stack_use (self);
}


static void _deque_tests_test_reversed_stack_use_gee_test_case_test_method (gpointer self) {
	deque_tests_test_reversed_stack_use (self);
}


DequeTests* deque_tests_construct (GType object_type, const char* name) {
	DequeTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (DequeTests*) queue_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Deque] queue use", _deque_tests_test_queue_use_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Deque] stack use", _deque_tests_test_stack_use_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Deque] reversed stack use", _deque_tests_test_reversed_stack_use_gee_test_case_test_method, self);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void deque_tests_test_queue_use (DequeTests* self) {
	GeeCollection* _tmp0_;
	GeeDeque* test_deque;
	GeeArrayList* recipient;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	g_return_if_fail (self != NULL);
	test_deque = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_DEQUE (_tmp0_) ? ((GeeDeque*) _tmp0_) : NULL));
	recipient = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (test_deque != NULL);
	g_assert (gee_deque_offer_tail (test_deque, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 1);
	g_assert (gee_deque_offer_tail (test_deque, "two"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 2);
	g_assert (gee_deque_offer_tail (test_deque, "three"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (gee_deque_offer_tail (test_deque, "four"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 4);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_deque_peek_head (test_deque), "one") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_deque_poll_head (test_deque), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_deque_peek_head (test_deque), "two") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_deque_poll_head (test_deque), "two") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 2);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_deque_peek_head (test_deque), "three") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_deque_poll_head (test_deque), "three") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 1);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_deque_peek_head (test_deque), "four") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_deque_poll_head (test_deque), "four") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert ((_tmp9_ = (char*) gee_deque_peek_head (test_deque)) == NULL);
	_g_free0 (_tmp9_);
	g_assert ((_tmp10_ = (char*) gee_deque_poll_head (test_deque)) == NULL);
	_g_free0 (_tmp10_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_offer_tail (test_deque, "one"));
	g_assert (gee_deque_offer_tail (test_deque, "two"));
	g_assert (gee_deque_offer_tail (test_deque, "three"));
	g_assert (gee_deque_offer_tail (test_deque, "four"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 4);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1) == 1);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 1);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 0), "one") == 0);
	_g_free0 (_tmp11_);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 4);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 1), "two") == 0);
	_g_free0 (_tmp12_);
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 2), "three") == 0);
	_g_free0 (_tmp13_);
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 3), "four") == 0);
	_g_free0 (_tmp14_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 0);
	_g_object_unref0 (test_deque);
	_g_object_unref0 (recipient);
}


void deque_tests_test_stack_use (DequeTests* self) {
	GeeCollection* _tmp0_;
	GeeDeque* test_deque;
	GeeArrayList* recipient;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	g_return_if_fail (self != NULL);
	test_deque = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_DEQUE (_tmp0_) ? ((GeeDeque*) _tmp0_) : NULL));
	recipient = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (test_deque != NULL);
	g_assert (gee_deque_offer_head (test_deque, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 1);
	g_assert (gee_deque_offer_head (test_deque, "two"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 2);
	g_assert (gee_deque_offer_head (test_deque, "three"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (gee_deque_offer_head (test_deque, "four"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 4);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_deque_peek_head (test_deque), "four") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_deque_poll_head (test_deque), "four") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_deque_peek_head (test_deque), "three") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_deque_poll_head (test_deque), "three") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 2);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_deque_peek_head (test_deque), "two") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_deque_poll_head (test_deque), "two") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 1);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_deque_peek_head (test_deque), "one") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_deque_poll_head (test_deque), "one") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert ((_tmp9_ = (char*) gee_deque_peek_head (test_deque)) == NULL);
	_g_free0 (_tmp9_);
	g_assert ((_tmp10_ = (char*) gee_deque_poll_head (test_deque)) == NULL);
	_g_free0 (_tmp10_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_offer_head (test_deque, "one"));
	g_assert (gee_deque_offer_head (test_deque, "two"));
	g_assert (gee_deque_offer_head (test_deque, "three"));
	g_assert (gee_deque_offer_head (test_deque, "four"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 4);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1) == 1);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 1);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 0), "four") == 0);
	_g_free0 (_tmp11_);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 4);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 1), "three") == 0);
	_g_free0 (_tmp12_);
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 2), "two") == 0);
	_g_free0 (_tmp13_);
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 3), "one") == 0);
	_g_free0 (_tmp14_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 0);
	_g_object_unref0 (test_deque);
	_g_object_unref0 (recipient);
}


void deque_tests_test_reversed_stack_use (DequeTests* self) {
	GeeCollection* _tmp0_;
	GeeDeque* test_deque;
	GeeArrayList* recipient;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	g_return_if_fail (self != NULL);
	test_deque = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_DEQUE (_tmp0_) ? ((GeeDeque*) _tmp0_) : NULL));
	recipient = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (test_deque != NULL);
	g_assert (gee_deque_offer_tail (test_deque, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 1);
	g_assert (gee_deque_offer_tail (test_deque, "two"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 2);
	g_assert (gee_deque_offer_tail (test_deque, "three"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (gee_deque_offer_tail (test_deque, "four"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 4);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_deque_peek_tail (test_deque), "four") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_deque_poll_tail (test_deque), "four") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_deque_peek_tail (test_deque), "three") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_deque_poll_tail (test_deque), "three") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 2);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_deque_peek_tail (test_deque), "two") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_deque_poll_tail (test_deque), "two") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 1);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_deque_peek_tail (test_deque), "one") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_deque_poll_tail (test_deque), "one") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert ((_tmp9_ = (char*) gee_deque_peek_tail (test_deque)) == NULL);
	_g_free0 (_tmp9_);
	g_assert ((_tmp10_ = (char*) gee_deque_poll_tail (test_deque)) == NULL);
	_g_free0 (_tmp10_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_offer_tail (test_deque, "one"));
	g_assert (gee_deque_offer_tail (test_deque, "two"));
	g_assert (gee_deque_offer_tail (test_deque, "three"));
	g_assert (gee_deque_offer_tail (test_deque, "four"));
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 4);
	g_assert (gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, 1) == 1);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 1);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 0), "four") == 0);
	_g_free0 (_tmp11_);
	g_assert (gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, -1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 4);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 1), "three") == 0);
	_g_free0 (_tmp12_);
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 2), "two") == 0);
	_g_free0 (_tmp13_);
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_abstract_list_get ((GeeAbstractList*) recipient, 3), "one") == 0);
	_g_free0 (_tmp14_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, 1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	g_assert (gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, -1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) test_deque) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) recipient) == 0);
	_g_object_unref0 (test_deque);
	_g_object_unref0 (recipient);
}


static void deque_tests_class_init (DequeTestsClass * klass) {
	deque_tests_parent_class = g_type_class_peek_parent (klass);
}


static void deque_tests_instance_init (DequeTests * self) {
}


GType deque_tests_get_type (void) {
	static volatile gsize deque_tests_type_id__volatile = 0;
	if (g_once_init_enter (&deque_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DequeTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deque_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DequeTests), 0, (GInstanceInitFunc) deque_tests_instance_init, NULL };
		GType deque_tests_type_id;
		deque_tests_type_id = g_type_register_static (TYPE_QUEUE_TESTS, "DequeTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&deque_tests_type_id__volatile, deque_tests_type_id);
	}
	return deque_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




