/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Stack;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AreaAPtg;
import org.apache.poi.hssf.record.formula.AreaNAPtg;
import org.apache.poi.hssf.record.formula.AreaNPtg;
import org.apache.poi.hssf.record.formula.AreaNVPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AreaVPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RefAPtg;
import org.apache.poi.hssf.record.formula.RefNAPtg;
import org.apache.poi.hssf.record.formula.RefNPtg;
import org.apache.poi.hssf.record.formula.RefNVPtg;
import org.apache.poi.hssf.record.formula.RefVPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;

public class SharedFormulaRecord
extends Record {
    public static final short sid = 1212;
    private int field_1_first_row;
    private int field_2_last_row;
    private short field_3_first_column;
    private short field_4_last_column;
    private int field_5_reserved;
    private short field_6_expression_len;
    private Stack field_7_parsed_expr;

    protected void validateSid(short id) {
        if (id != 1212) {
            throw new RecordFormatException("Not a valid SharedFormula");
        }
    }

    public int getFirstRow() {
        return this.field_1_first_row;
    }

    public int getLastRow() {
        return this.field_2_last_row;
    }

    public short getFirstColumn() {
        return this.field_3_first_column;
    }

    public short getLastColumn() {
        return this.field_4_last_column;
    }

    public short getExpressionLength() {
        return this.field_6_expression_len;
    }

    public int serialize(int offset, byte[] data) {
        throw new UnsupportedOperationException("Cannot serialize a SharedFormulaRecord");
    }

    public int getRecordSize() {
        throw new UnsupportedOperationException("Cannot get the size for a SharedFormulaRecord");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SHARED FORMULA RECORD:" + Integer.toHexString(1212) + "]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(1212)).append("\n");
        buffer.append("    .first_row       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        buffer.append("    .last_row    = ").append(Integer.toHexString(this.getLastRow())).append("\n");
        buffer.append("    .first_column       = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append("    .last_column    = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        buffer.append("    .reserved    = ").append(Integer.toHexString(this.field_5_reserved)).append("\n");
        buffer.append("    .expressionlength= ").append(this.getExpressionLength()).append("\n");
        buffer.append("    .numptgsinarray  = ").append(this.field_7_parsed_expr.size()).append("\n");
        int k = 0;
        while (k < this.field_7_parsed_expr.size()) {
            buffer.append("Formula ").append(k).append("\n").append(this.field_7_parsed_expr.get(k).toString()).append("\n");
            ++k;
        }
        buffer.append("[/SHARED FORMULA RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 1212;
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_first_row = in.readShort();
        this.field_2_last_row = in.readShort();
        this.field_3_first_column = in.readByte();
        this.field_4_last_column = in.readByte();
        this.field_5_reserved = in.readShort();
        this.field_6_expression_len = in.readShort();
        this.field_7_parsed_expr = this.getParsedExpressionTokens(in);
    }

    private final Stack getParsedExpressionTokens(RecordInputStream in) {
        Stack<Ptg> stack = new Stack<Ptg>();
        while (in.remaining() != 0) {
            Ptg ptg = Ptg.createPtg(in);
            stack.push(ptg);
        }
        return stack;
    }

    public boolean isFormulaInShared(FormulaRecord formula) {
        int formulaRow = formula.getRow();
        short formulaColumn = formula.getColumn();
        boolean bl = false;
        if (this.getFirstRow() <= formulaRow && this.getLastRow() >= formulaRow && this.getFirstColumn() <= formulaColumn && this.getLastColumn() >= formulaColumn) {
            bl = true;
        }
        return bl;
    }

    public void convertSharedFormulaRecord(FormulaRecord formula) {
        Stack<Ptg> newPtgStack;
        int formulaRow = formula.getRow();
        short formulaColumn = formula.getColumn();
        if (this.isFormulaInShared(formula)) {
            formula.setExpressionLength(this.getExpressionLength());
            newPtgStack = new Stack<Ptg>();
            if (this.field_7_parsed_expr != null) {
                int k = 0;
                while (k < this.field_7_parsed_expr.size()) {
                    Ptg ptg = (Ptg)this.field_7_parsed_expr.get(k);
                    if (ptg instanceof RefNPtg) {
                        RefNPtg refNPtg = (RefNPtg)ptg;
                        ptg = new ReferencePtg((short)(formulaRow + refNPtg.getRow()), (byte)(formulaColumn + refNPtg.getColumn()), refNPtg.isRowRelative(), refNPtg.isColRelative());
                    } else if (ptg instanceof RefNVPtg) {
                        RefNVPtg refNVPtg = (RefNVPtg)ptg;
                        ptg = new RefVPtg((short)(formulaRow + refNVPtg.getRow()), (byte)(formulaColumn + refNVPtg.getColumn()), refNVPtg.isRowRelative(), refNVPtg.isColRelative());
                    } else if (ptg instanceof RefNAPtg) {
                        RefNAPtg refNAPtg = (RefNAPtg)ptg;
                        ptg = new RefAPtg((short)(formulaRow + refNAPtg.getRow()), (byte)(formulaColumn + refNAPtg.getColumn()), refNAPtg.isRowRelative(), refNAPtg.isColRelative());
                    } else if (ptg instanceof AreaNPtg) {
                        AreaNPtg areaNPtg = (AreaNPtg)ptg;
                        ptg = new AreaPtg((short)(formulaRow + areaNPtg.getFirstRow()), (short)(formulaRow + areaNPtg.getLastRow()), (short)(formulaColumn + areaNPtg.getFirstColumn()), (short)(formulaColumn + areaNPtg.getLastColumn()), areaNPtg.isFirstRowRelative(), areaNPtg.isLastRowRelative(), areaNPtg.isFirstColRelative(), areaNPtg.isLastColRelative());
                    } else if (ptg instanceof AreaNVPtg) {
                        AreaNVPtg areaNVPtg = (AreaNVPtg)ptg;
                        ptg = new AreaVPtg((short)(formulaRow + areaNVPtg.getFirstRow()), (short)(formulaRow + areaNVPtg.getLastRow()), (short)(formulaColumn + areaNVPtg.getFirstColumn()), (short)(formulaColumn + areaNVPtg.getLastColumn()), areaNVPtg.isFirstRowRelative(), areaNVPtg.isLastRowRelative(), areaNVPtg.isFirstColRelative(), areaNVPtg.isLastColRelative());
                    } else if (ptg instanceof AreaNAPtg) {
                        AreaNAPtg areaNAPtg = (AreaNAPtg)ptg;
                        ptg = new AreaAPtg((short)(formulaRow + areaNAPtg.getFirstRow()), (short)(formulaRow + areaNAPtg.getLastRow()), (short)(formulaColumn + areaNAPtg.getFirstColumn()), (short)(formulaColumn + areaNAPtg.getLastColumn()), areaNAPtg.isFirstRowRelative(), areaNAPtg.isLastRowRelative(), areaNAPtg.isFirstColRelative(), areaNAPtg.isLastColRelative());
                    }
                    newPtgStack.add(ptg);
                    ++k;
                }
            }
        } else {
            throw new RuntimeException("Shared Formula Conversion: Coding Error");
        }
        formula.setParsedExpression(newPtgStack);
        formula.setSharedFormula(false);
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object clone() {
        throw new UnsupportedOperationException("Cannot clone a SharedFormulaRecord");
    }

    public SharedFormulaRecord() {
    }

    public SharedFormulaRecord(RecordInputStream in) {
        super(in);
    }
}

