/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class FnGroupCountRecord
extends Record {
    public static final short sid = 156;
    public static final short COUNT = 14;
    private short field_1_count;

    protected void validateSid(short id) {
        if (id != 156) {
            throw new RecordFormatException("NOT A FNGROUPCOUNT RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_count = in.readShort();
    }

    public void setCount(short count) {
        this.field_1_count = count;
    }

    public short getCount() {
        return this.field_1_count;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FNGROUPCOUNT]\n");
        buffer.append("    .count            = ").append(this.getCount()).append("\n");
        buffer.append("[/FNGROUPCOUNT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)156);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getCount());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 156;
    }

    public FnGroupCountRecord() {
    }

    public FnGroupCountRecord(RecordInputStream in) {
        super(in);
    }
}

