/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DrawingManager {
    EscherDggRecord dgg;
    Map dgMap;

    public EscherDgRecord createDgRecord() {
        EscherDgRecord dg = new EscherDgRecord();
        dg.setRecordId((short)-4088);
        short dgId = this.findNewDrawingGroupId();
        dg.setOptions((short)(dgId << 4));
        dg.setNumShapes(0);
        dg.setLastMSOSPID(-1);
        this.dgg.addCluster(dgId, 0);
        this.dgg.setDrawingsSaved(this.dgg.getDrawingsSaved() + 1);
        this.dgMap.put(new Short(dgId), dg);
        return dg;
    }

    public int allocateShapeId(short drawingGroupId) {
        EscherDgRecord dg = (EscherDgRecord)this.dgMap.get(new Short(drawingGroupId));
        int lastShapeId = dg.getLastMSOSPID();
        int newShapeId = 0;
        if (lastShapeId % 1024 == 1023) {
            newShapeId = this.findFreeSPIDBlock();
            this.dgg.addCluster(drawingGroupId, 1);
        } else {
            int i = 0;
            while (i < this.dgg.getFileIdClusters().length) {
                EscherDggRecord.FileIdCluster c = this.dgg.getFileIdClusters()[i];
                if (c.getDrawingGroupId() == drawingGroupId && c.getNumShapeIdsUsed() != 1024) {
                    c.incrementShapeId();
                }
                newShapeId = dg.getLastMSOSPID() == -1 ? this.findFreeSPIDBlock() : dg.getLastMSOSPID() + 1;
                ++i;
            }
        }
        this.dgg.setNumShapesSaved(this.dgg.getNumShapesSaved() + 1);
        if (newShapeId >= this.dgg.getShapeIdMax()) {
            this.dgg.setShapeIdMax(newShapeId + 1);
        }
        dg.setLastMSOSPID(newShapeId);
        dg.incrementShapeCount();
        return newShapeId;
    }

    short findNewDrawingGroupId() {
        short dgId = 1;
        while (this.drawingGroupExists(dgId)) {
            dgId = (short)(dgId + 1);
        }
        return dgId;
    }

    boolean drawingGroupExists(short dgId) {
        int i = 0;
        while (i < this.dgg.getFileIdClusters().length) {
            if (this.dgg.getFileIdClusters()[i].getDrawingGroupId() == dgId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int findFreeSPIDBlock() {
        int max = this.dgg.getShapeIdMax();
        int next = (max / 1024 + 1) * 1024;
        return next;
    }

    public EscherDggRecord getDgg() {
        return this.dgg;
    }

    private final /* synthetic */ void this() {
        this.dgMap = new HashMap();
    }

    public DrawingManager(EscherDggRecord dgg) {
        this.this();
        this.dgg = dgg;
    }
}

