/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherChildAnchorRecord
extends EscherRecord {
    public static final short RECORD_ID = -4081;
    public static final String RECORD_DESCRIPTION = "MsofbtChildAnchor";
    private int field_1_dx1;
    private int field_2_dy1;
    private int field_3_dx2;
    private int field_4_dy2;

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        int size = 0;
        this.field_1_dx1 = LittleEndian.getInt(data, pos + size);
        this.field_2_dy1 = LittleEndian.getInt(data, pos + (size += 4));
        this.field_3_dx2 = LittleEndian.getInt(data, pos + (size += 4));
        this.field_4_dy2 = LittleEndian.getInt(data, pos + (size += 4));
        return 8 + (size += 4);
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        int pos = offset;
        LittleEndian.putShort(data, pos, this.getOptions());
        LittleEndian.putShort(data, pos += 2, this.getRecordId());
        LittleEndian.putInt(data, pos += 2, this.getRecordSize() - 8);
        LittleEndian.putInt(data, pos += 4, this.field_1_dx1);
        LittleEndian.putInt(data, pos += 4, this.field_2_dy1);
        LittleEndian.putInt(data, pos += 4, this.field_3_dx2);
        LittleEndian.putInt(data, pos += 4, this.field_4_dy2);
        listener.afterRecordSerialize(pos += 4, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public int getRecordSize() {
        return 24;
    }

    public short getRecordId() {
        return -4081;
    }

    public String getRecordName() {
        return "ChildAnchor";
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        return this.getClass().getName() + ':' + nl + "  RecordId: 0x" + HexDump.toHex((short)-4081) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  X1: " + this.field_1_dx1 + nl + "  Y1: " + this.field_2_dy1 + nl + "  X2: " + this.field_3_dx2 + nl + "  Y2: " + this.field_4_dy2 + nl;
    }

    public int getDx1() {
        return this.field_1_dx1;
    }

    public void setDx1(int field_1_dx1) {
        this.field_1_dx1 = field_1_dx1;
    }

    public int getDy1() {
        return this.field_2_dy1;
    }

    public void setDy1(int field_2_dy1) {
        this.field_2_dy1 = field_2_dy1;
    }

    public int getDx2() {
        return this.field_3_dx2;
    }

    public void setDx2(int field_3_dx2) {
        this.field_3_dx2 = field_3_dx2;
    }

    public int getDy2() {
        return this.field_4_dy2;
    }

    public void setDy2(int field_4_dy2) {
        this.field_4_dy2 = field_4_dy2;
    }
}

