/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "worditem.h"
#include "type.h"
#include <kdebug.h>

WordItem::WordItem( KListView* parent, Word word )
: KListViewItem( parent )
, m_word( word )
{
	setEachText();
}

Word WordItem::word()
{
	return m_word;
}

void WordItem::setWord( Word word )
{
	m_word = word;
	setEachText();
}

void WordItem::setEachText()
{
	setText( 0, m_word.from );
	setText( 1, m_word.to );
	setText( 2, m_word.type.toString() );
	setText( 3, QString( "%1" ).arg( m_word.freq ) );
}
