/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "editcommand.h"
#include "dlgedit.h"
#include <qheader.h>

EditCommand::EditCommand( KListView* parent )
{
	m_parent = parent;
	m_succeed = false;
	dlgEdit dlgedit( parent );
	dlgedit.setEditMode( dlgEdit::EDIT, parent->header()->count() == 4 );

	QListViewItem* item = parent->selectedItems().first();
	parent->ensureItemVisible( item );
	dlgedit.setWordItem( (WordItem*)item );
	dlgedit.exec();

	if( dlgedit.result() ){
		Word before = ((WordItem*)item)->word();
		Word after = dlgedit.word();
		if( before.from != after.from || before.to != after.to || !( before.type == after.type ) || before.freq != after.freq ){
			((WordItem*)item)->setWord( before );
			m_item = (WordItem*)item;
			m_before = before;
			m_after = after;
			m_succeed = true;
		}
	}else{
		m_succeed = false;
	}
}

bool EditCommand::succeed()
{
	return m_succeed;
}

QString EditCommand::name() const
{
	return i18n( "edited %1 to %2" ).arg( m_before.from ).arg( m_after.from );
}

void EditCommand::execute()
{
	m_parent->clearSelection();
	m_item->setWord( m_after );
	m_parent->setSelected( m_item, true );
	m_parent->ensureItemVisible( m_item );
}

void EditCommand::unexecute()
{
	m_parent->clearSelection();
	m_item->setWord( m_before );
	m_parent->setSelected( m_item, true );
	m_parent->ensureItemVisible( m_item );
}

