#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-widgets.h"
#include "gnubversion-gladepath.h"
#include "gnubversion-init.h"

#include <assert.h>
#include <glade/glade.h>
#include <gtk/gtk.h>

GtkWidget *
gnubversion_get_widget(const char *widget_name)
{
    GtkWidget *widget = glade_xml_get_widget (gnubversion_gladeXML, widget_name);
    if (widget == NULL)
        g_error("Cannot locate widget named \"%s\" !", widget_name);

    return widget;
}

GString *
gladefile(const char *file, const char *extension)
{
    GString *str;
    
    str = g_string_new(get_gladepath());

    g_string_append(str, "/");
    g_string_append(str, file);
    if (extension != NULL)
        g_string_append(str, extension);
    return str;
}

#define STATIC_BUFSIZ 500

const char *
gladefile_static(const char *file, const char *extension)
{
    static char result[STATIC_BUFSIZ];
    GString *str = gladefile(file, extension);
    assert(strlen(str->str) < (STATIC_BUFSIZ-1));
    strcpy(result, str->str);
    g_string_free(str, TRUE);
    return result;
}

void 
gnubversion_set_icon(const char *widget_name, const char *icon_name)
{
    GtkWidget *widget = gnubversion_get_widget(widget_name);
    assert (GTK_IS_IMAGE(widget));

    GString *str = gladefile(icon_name, ".png");

    if ( g_file_test( str->str, G_FILE_TEST_EXISTS) )
        gtk_image_set_from_file(GTK_IMAGE(widget), str->str);
    else
        g_warning("File %s not found. Buttons will be missing images", str->str);

    g_string_free(str, TRUE);
}

