#ifndef GNUBVERSION_PRIVATE_H
#define GNUBVERSION_PRIVATE_H

#define apr_assert(apr_status) \
    do {\
        apr_status_t __t=apr_status; \
        if (__t != APR_SUCCESS) { \
            char buf[500]; \
            fprintf(stderr, "libgnubversion(%s line %d: %s)\n", \
                    __FILE__, __LINE__, apr_strerror(__t, buf, sizeof(buf) )); \
            abort(); \
        } \
    } while (0)

#define svn_assert(svn_err) \
    do {\
        svn_error_t *__err = (svn_err); \
        if (__err != NULL) { \
            svn_handle_error2(__err, stderr, TRUE, "libgnubversion:"); \
        } \
    } while (0)

#endif
