#ifndef GNUBVERSION_DEBUG_H
#define GNUBVERSION_DEBUG_H

#include <glib/gmacros.h>

#ifdef G_HAVE_ISO_VARARGS

# ifdef DEBUG
#  define gvn_debug(...) g_debug(__VA_ARGS__)
# else
#  define gvn_debug(...) G_STMT_START{ (void)0; /* __VA_ARGS __ */ }G_STMT_END
# endif

#elif defined(G_HAVE_GNUC_VARARGS)

# ifdef DEBUG
#  define gvn_debug(format...) g_debug(format)
# else 
#  define gvn_debug(format...) G_STMT_START{ (void)0; /* format */ }G_STMT_END
# endif

#else

# ifdef DEBUG
#  define gvn_debug g_debug
# else
#  warn "Enabling debugging anyway"
#  define gvn_debug g_debug
# endif

#endif /* ifdef G_HAVE_ISO_VARARGS */

#endif /* defined GNUBVERSION_H */
