#ifndef GNUBVERSION_AUTH_H
#define GNUBVERSION_AUTH_H

#include <svn_error.h>
#include <svn_auth.h>
#include <gnubversion-threadmessage.h>
#include <gnubversion-progresswindow.h>

typedef struct
{
  /*
  apr_hash_t *tables;
  apr_pool_t *pool;
  */
  GnubVersionProgressWindow *progressWindow;
} gnubversion_auth_baton_t;

/* TODO: See subversion/libsvn_subr/prompt.c for more */
extern svn_error_t *
gnubversion_auth_simple_prompt ( svn_auth_cred_simple_t **cred_p,
                                void *baton,
                                const char *realm,
                                const char *username,
                                svn_boolean_t may_save,
                                apr_pool_t *pool);

extern svn_error_t *
gnubversion_auth_username_prompt (  svn_auth_cred_username_t **cred_p,
                                    void *baton,
                                    const char *realm,
                                    svn_boolean_t may_save,
                                    apr_pool_t *pool);

extern svn_error_t *
gnubversion_auth_ssl_server_trust_prompt(
    svn_auth_cred_ssl_server_trust_t **cred_p,
    void *baton,
    const char *realm,
    apr_uint32_t failures,
    const svn_auth_ssl_server_cert_info_t *cert_info,
    svn_boolean_t may_save,
    apr_pool_t *pool);

#endif
