#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-gerror.h"
#include <glib.h>

#define ERR_BUF_SIZE  3000

GError *
g_error_from_apr(apr_status_t apr_status)
{
    char errbuf[ERR_BUF_SIZE];
    char *err;

    err = apr_strerror(apr_status, errbuf, sizeof(errbuf));

    GError *ret;

    ret = g_error_new_literal(GNUBVERSION_QUARK_APR, apr_status, err);

    return ret;
}

GError *
g_error_from_svn( svn_error_t *err)
{
    GError *ret;

    char *buf = g_malloc(ERR_BUF_SIZE);
    const char *errbuf = svn_err_best_message(err, buf, ERR_BUF_SIZE);

    ret = g_error_new_literal(GNUBVERSION_QUARK_SVN, err->apr_err, errbuf);

    return ret;
}

GError *
g_error_from_linux (int new_errno)
{
    GError *ret;

    ret = g_error_new_literal (GNUBVERSION_QUARK_LINUX, new_errno, strerror(new_errno));
    return ret;
}

