#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <gnubversion.h>
#include <assert.h>
#include "gvn-commit.h"

#define APP_NAME "gvn-commit"

int 
main (
    int argc, 
    char **argv, 
    char **env
    )
{
    #ifdef ENABLE_NLS
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        textdomain (PACKAGE);
    #endif

    const gchar **remaining_args = NULL;
    gboolean non_recursive = FALSE;
    GString *log_message;
    int exitcode = 0;

    log_message = g_string_new("");

    GOptionEntry option_entries[] = 
    {
        /* ... your application's command line options go here ... */
        {
            "non-recursive", 'N',
            0, 
            G_OPTION_ARG_NONE,
            &non_recursive,
            _("operate on single directory only"),
            NULL
        },
        {
            "message", 'm',
            0, 
            G_OPTION_ARG_STRING,
            log_message,
            _("specify log message"),
            _("message")
        },
        { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
          &remaining_args,
          "Special option that collects any remaining arguments for us" },
        { NULL }
    };

    GOptionContext *option_context;
    GnomeProgram *my_app;

    option_context = g_option_context_new ( "[ filename ... ]" );

    g_option_context_add_main_entries (option_context, option_entries, GETTEXT_PACKAGE);

    g_option_context_add_group( option_context, gnubversion_get_option_group() );

    my_app = gnome_program_init(APP_NAME, VERSION,
                                LIBGNOMEUI_MODULE, argc, argv,
                                GNOME_PARAM_GOPTION_CONTEXT, option_context,
                                GNOME_PARAM_NONE);

    gnubversion_init_with_glade(APP_NAME);

    if (remaining_args == NULL)
    {
        const gchar *newargs[] = { "", NULL };
        dialog_init(non_recursive, newargs, log_message);
    }
    else
        dialog_init(non_recursive, remaining_args, log_message);

    dialog_run();
    dialog_shutdown();

    gnubversion_shutdown ();
    g_object_unref ( my_app );
    return exitcode;
}

