#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define LOG_DOMAIN "gvn-revert"

#include <gtk/gtk.h>
#include "gvn-addremove.h"

#define RECURSIVE GTK_TOGGLE_BUTTON(gnubversion_get_widget("recursive") )

const char *appname = "gvn-revert";
const char *appwidget_name = "revertApp";
const char *get_initial_progressmessage()
{
    return _("Preparing Reversal...");
}

const char *get_fileselector_title(void)
{
    return _("Paths to Revert:");
}

const char *get_tick_column_title(void)
{
    return _("Revert");
}

void set_gui_options(struct baton *baton)
{
    gtk_toggle_button_set_active ( RECURSIVE, baton->recursive);
}

void get_gui_options(struct baton *baton)
{
    baton->recursive = gtk_toggle_button_get_active ( RECURSIVE );
}

/* Decides which files should be included in the FileSelector */
gboolean include_func (const gchar *path, 
                      svn_wc_status2_t *status, 
                      gpointer user_data)
{
    switch (status->text_status)
    {
        case svn_wc_status_modified: /** text or props have been modified */
        case svn_wc_status_merged: /** local mods received repos mods */
        case svn_wc_status_conflicted: /** local mods received conflicting repos mods */
        case svn_wc_status_added: /** is scheduled for addition */
        case svn_wc_status_deleted: /** scheduled for deletion */
        case svn_wc_status_obstructed: /** an unversioned resource is in the way of the versioned resource */
        case svn_wc_status_replaced: /** was deleted and then re-added */
            return TRUE;
        case svn_wc_status_none: /** does not exist */
        case svn_wc_status_external: /** an unversioned path populated by an svn:externals property */
        case svn_wc_status_incomplete: /** a directory doesn't contain a complete entries list */
        case svn_wc_status_ignored: /** is unversioned but configured to be ignored */
        case svn_wc_status_unversioned: /** is not a versioned thing in this wc */
        case svn_wc_status_normal: /** exists, but uninteresting */
        case svn_wc_status_missing: /** under v.c., but is missing */
            return FALSE;

        default:
            g_warning("Unknown text status %d - ignoring file %p", status->text_status, path);
            return FALSE;
    }
}

GOptionEntry *get_option_entries(
        const gchar ***args,
        struct baton *baton)
{
    GOptionEntry option_entries[] = 
    {
        /* ... your application's command line options go here ... */
        {
            "recursive", 0,
            0, 
            G_OPTION_ARG_NONE,
            &baton->recursive,
            _("descend recursively"),
            NULL
        },
        { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
          args,
          "Special option that collects any remaining arguments for us" },
        { NULL }
    };

    GOptionEntry *retval = g_malloc(sizeof(option_entries));

    memcpy(retval, option_entries, sizeof(option_entries));

    return retval;
}

svn_error_t * do_add_remove(
    apr_array_header_t *targets,
    struct baton *baton)
{
    return svn_client_revert(  targets,
                                baton->recursive,
                                gnubversion_svn_client_ctx,
                                gnubversion_apr_pool);
}
