"/* The standard CSS for doxygen */\n"
"\n"
"body, table, div, p, dl {\n"
"	font-family: Lucida Grande, Verdana, Geneva, Arial, sans-serif;\n"
"	font-size: 12px;\n"
"}\n"
"\n"
"/* @group Heading Levels */\n"
"\n"
"h1 {\n"
"	font-size: 150%;\n"
"}\n"
"\n"
"h2 {\n"
"	font-size: 120%;\n"
"}\n"
"\n"
"h3 {\n"
"	font-size: 100%;\n"
"}\n"
"\n"
"dt {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"div.multicol {\n"
"	-moz-column-gap: 1em;\n"
"	-webkit-column-gap: 1em;\n"
"	-moz-column-count: 3;\n"
"	-webkit-column-count: 3;\n"
"}\n"
"\n"
"p.startli, p.startdd, p.starttd {\n"
"	margin-top: 2px;\n"
"}\n"
"\n"
"p.endli {\n"
"	margin-bottom: 0px;\n"
"}\n"
"\n"
"p.enddd {\n"
"	margin-bottom: 4px;\n"
"}\n"
"\n"
"p.endtd {\n"
"	margin-bottom: 2px;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"caption {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"span.legend {\n"
"        font-size: 70%;\n"
"        text-align: center;\n"
"}\n"
"\n"
"h3.version {\n"
"        font-size: 90%;\n"
"        text-align: center;\n"
"}\n"
"\n"
"div.qindex, div.navtab{\n"
"	background-color: ##ee;\n"
"	border: 1px solid ##b0;\n"
"	text-align: center;\n"
"	margin: 2px;\n"
"	padding: 2px;\n"
"}\n"
"\n"
"div.qindex, div.navpath {\n"
"	width: 100%;\n"
"	line-height: 140%;\n"
"}\n"
"\n"
"div.navtab {\n"
"	margin-right: 15px;\n"
"}\n"
"\n"
"/* @group Link Styling */\n"
"\n"
"a {\n"
"	color: ##50;\n"
"	font-weight: normal;\n"
"	text-decoration: none;\n"
"}\n"
"\n"
".contents a:visited {\n"
"	color: ##60;\n"
"}\n"
"\n"
"a:hover {\n"
"	text-decoration: underline;\n"
"}\n"
"\n"
"a.qindex {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"a.qindexHL {\n"
"	font-weight: bold;\n"
"	background-color: ##AA;\n"
"	color: #ffffff;\n"
"	border: 1px double ##98;\n"
"}\n"
"\n"
".contents a.qindexHL:visited {\n"
"        color: #ffffff;\n"
"}\n"
"\n"
"a.el {\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"a.elRef {\n"
"}\n"
"\n"
"a.code {\n"
"	color: ##60;\n"
"}\n"
"\n"
"a.codeRef {\n"
"	color: ##60;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"dl.el {\n"
"	margin-left: -1cm;\n"
"}\n"
"\n"
".fragment {\n"
"	font-family: monospace, fixed;\n"
"	font-size: 105%;\n"
"}\n"
"\n"
"pre.fragment {\n"
"	border: 1px solid ##CC;\n"
"	background-color: ##FC;\n"
"	padding: 4px 6px;\n"
"	margin: 4px 8px 4px 2px;\n"
"	overflow: auto;\n"
"	word-wrap: break-word;\n"
"	font-size:  9pt;\n"
"	line-height: 125%;\n"
"}\n"
"\n"
"div.ah {\n"
"	background-color: black;\n"
"	font-weight: bold;\n"
"	color: #ffffff;\n"
"	margin-bottom: 3px;\n"
"	margin-top: 3px;\n"
"	padding: 0.2em;\n"
"	border: solid thin #333;\n"
"	border-radius: 0.5em;\n"
"	-webkit-border-radius: .5em;\n"
"	-moz-border-radius: .5em;\n"
"	-webkit-box-shadow: 2px 2px 3px #999;\n"
"	-moz-box-shadow: rgba(0, 0, 0, 0.15) 2px 2px 2px;\n"
"	background-image: -webkit-gradient(linear, left top, left bottom, from(#eee), to(#000),color-stop(0.3, #444));\n"
"	background-image: -moz-linear-gradient(center top, #eee 0%, #444 40%, #000);\n"
"}\n"
"\n"
"div.groupHeader {\n"
"	margin-left: 16px;\n"
"	margin-top: 12px;\n"
"	margin-bottom: 6px;\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"div.groupText {\n"
"	margin-left: 16px;\n"
"	font-style: italic;\n"
"}\n"
"\n"
"body {\n"
"	background: white;\n"
"	color: black;\n"
"        margin: 0;\n"
"}\n"
"\n"
"div.contents {\n"
"	margin-top: 10px;\n"
"	margin-left: 10px;\n"
"	margin-right: 10px;\n"
"}\n"
"\n"
"td.indexkey {\n"
"	background-color: ##ee;\n"
"	font-weight: bold;\n"
"	border: 1px solid ##cc;\n"
"	margin: 2px 0px 2px 0;\n"
"	padding: 2px 10px;\n"
"}\n"
"\n"
"td.indexvalue {\n"
"	background-color: ##ee;\n"
"	border: 1px solid ##cc;\n"
"	padding: 2px 10px;\n"
"	margin: 2px 0px;\n"
"}\n"
"\n"
"tr.memlist {\n"
"	background-color: ##f0;\n"
"}\n"
"\n"
"p.formulaDsp {\n"
"	text-align: center;\n"
"}\n"
"\n"
"img.formulaDsp {\n"
"	\n"
"}\n"
"\n"
"img.formulaInl {\n"
"	vertical-align: middle;\n"
"}\n"
"\n"
"div.center {\n"
"	text-align: center;\n"
"        margin-top: 0px;\n"
"        margin-bottom: 0px;\n"
"        padding: 0px;\n"
"}\n"
"\n"
"div.center img {\n"
"	border: 0px;\n"
"}\n"
"\n"
"address.footer {\n"
"	text-align: right;\n"
"	padding-right: 12px;\n"
"}\n"
"\n"
"img.footer {\n"
"	border: 0px;\n"
"	vertical-align: middle;\n"
"}\n"
"\n"
"/* @group Code Colorization */\n"
"\n"
"span.keyword {\n"
"	color: #008000\n"
"}\n"
"\n"
"span.keywordtype {\n"
"	color: #604020\n"
"}\n"
"\n"
"span.keywordflow {\n"
"	color: #e08000\n"
"}\n"
"\n"
"span.comment {\n"
"	color: #800000\n"
"}\n"
"\n"
"span.preprocessor {\n"
"	color: #806020\n"
"}\n"
"\n"
"span.stringliteral {\n"
"	color: #002080\n"
"}\n"
"\n"
"span.charliteral {\n"
"	color: #008080\n"
"}\n"
"\n"
"span.vhdldigit { \n"
"	color: #ff00ff \n"
"}\n"
"\n"
"span.vhdlchar { \n"
"	color: #000000 \n"
"}\n"
"\n"
"span.vhdlkeyword { \n"
"	color: #700070 \n"
"}\n"
"\n"
"span.vhdllogic { \n"
"	color: #ff0000 \n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"/*\n"
".search {\n"
"	color: #003399;\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"form.search {\n"
"	margin-bottom: 0px;\n"
"	margin-top: 0px;\n"
"}\n"
"\n"
"input.search {\n"
"	font-size: 75%;\n"
"	color: #000080;\n"
"	font-weight: normal;\n"
"	background-color: #e8eef2;\n"
"}\n"
"*/\n"
"\n"
"td.tiny {\n"
"	font-size: 75%;\n"
"}\n"
"\n"
".dirtab {\n"
"	padding: 4px;\n"
"	border-collapse: collapse;\n"
"	border: 1px solid ##b0;\n"
"}\n"
"\n"
"th.dirtab {\n"
"	background: ##ee;\n"
"	font-weight: bold;\n"
"}\n"
"\n"
"hr {\n"
"	height: 0px;\n"
"	border: none;\n"
"	border-top: 1px solid ##66;\n"
"}\n"
"\n"
"hr.footer {\n"
"	height: 1px;\n"
"}\n"
"\n"
"/* @group Member Descriptions */\n"
"\n"
"table.memberdecls {\n"
"	border-spacing: 0px;\n"
"	padding: 0px;\n"
"}\n"
"\n"
".mdescLeft, .mdescRight,\n"
".memItemLeft, .memItemRight,\n"
".memTemplItemLeft, .memTemplItemRight, .memTemplParams {\n"
"	background-color: ##FA;\n"
"	border: none;\n"
"	margin: 4px;\n"
"	padding: 1px 0 0 8px;\n"
"}\n"
"\n"
".mdescLeft, .mdescRight {\n"
"	padding: 0px 8px 4px 8px;\n"
"	color: #555;\n"
"}\n"
"\n"
".memItemLeft, .memItemRight, .memTemplParams {\n"
"	border-top: 1px solid ##cc;\n"
"}\n"
"\n"
".memItemLeft, .memTemplItemLeft {\n"
"        white-space: nowrap;\n"
"}\n"
"\n"
".memTemplParams {\n"
"	color: ##60;\n"
"        white-space: nowrap;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"/* @group Member Details */\n"
"\n"
"/* Styles for detailed member documentation */\n"
"\n"
".memtemplate {\n"
"	font-size: 80%;\n"
"	color: ##60;\n"
"	font-weight: normal;\n"
"	margin-left: 3px;\n"
"}\n"
"\n"
".memnav {\n"
"	background-color: ##ee;\n"
"	border: 1px solid ##b0;\n"
"	text-align: center;\n"
"	margin: 2px;\n"
"	margin-right: 15px;\n"
"	padding: 2px;\n"
"}\n"
"\n"
".memitem {\n"
"	padding: 0;\n"
"	margin-bottom: 10px;\n"
"}\n"
"\n"
".memname {\n"
"        white-space: nowrap;\n"
"        font-weight: bold;\n"
"        margin-left: 6px;\n"
"}\n"
"\n"
".memproto {\n"
"        border-top: 1px solid ##B4;\n"
"        border-left: 1px solid ##B4;\n"
"        border-right: 1px solid ##B4;\n"
"        padding: 6px 0px 6px 0px;\n"
"        color: ##2b;\n"
"        font-weight: bold;\n"
"        text-shadow: 0px 1px 1px rgba(255, 255, 255, 0.9);\n"
"        /* firefox specific markup */\n"
"        -moz-box-shadow: rgba(0, 0, 0, 0.15) 5px 5px 5px;\n"
"        -moz-border-radius-topright: 8px;\n"
"        -moz-border-radius-topleft: 8px;\n"
"        /* webkit specific markup */\n"
"        -webkit-box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.15);\n"
"        -webkit-border-top-right-radius: 8px;\n"
"        -webkit-border-top-left-radius: 8px;\n"
"        background-image:url('nav_f.png');\n"
"        background-repeat:repeat-x;\n"
"        background-color: ##E6;\n"
"\n"
"}\n"
"\n"
".memdoc {\n"
"        border-bottom: 1px solid ##B4;      \n"
"        border-left: 1px solid ##B4;      \n"
"        border-right: 1px solid ##B4; \n"
"        padding: 2px 5px;\n"
"        background-color: ##FC;\n"
"        border-top-width: 0;\n"
"        /* firefox specific markup */\n"
"        -moz-border-radius-bottomleft: 8px;\n"
"        -moz-border-radius-bottomright: 8px;\n"
"        -moz-box-shadow: rgba(0, 0, 0, 0.15) 5px 5px 5px;\n"
"        background-image: -moz-linear-gradient(center top, ##FF 0%, ##FF 60%, ##F8 95%, ##F0);\n"
"        /* webkit specific markup */\n"
"        -webkit-border-bottom-left-radius: 8px;\n"
"        -webkit-border-bottom-right-radius: 8px;\n"
"        -webkit-box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.15);\n"
"        background-image: -webkit-gradient(linear,center top,center bottom,from(##FF), color-stop(0.6,##FF), color-stop(0.60,##FF), color-stop(0.95,##F8), to(##F0));\n"
"}\n"
"\n"
".paramkey {\n"
"	text-align: right;\n"
"}\n"
"\n"
".paramtype {\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
".paramname {\n"
"	color: #602020;\n"
"	white-space: nowrap;\n"
"}\n"
".paramname em {\n"
"	font-style: normal;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"/* @group Directory (tree) */\n"
"\n"
"/* for the tree view */\n"
"\n"
".ftvtree {\n"
"	font-family: sans-serif;\n"
"	margin: 0px;\n"
"}\n"
"\n"
"/* these are for tree view when used as main index */\n"
"\n"
".directory {\n"
"	font-size: 9pt;\n"
"	font-weight: bold;\n"
"	margin: 5px;\n"
"}\n"
"\n"
".directory h3 {\n"
"	margin: 0px;\n"
"	margin-top: 1em;\n"
"	font-size: 11pt;\n"
"}\n"
"\n"
"/*\n"
"The following two styles can be used to replace the root node title\n"
"with an image of your choice.  Simply uncomment the next two styles,\n"
"specify the name of your image and be sure to set 'height' to the\n"
"proper pixel height of your image.\n"
"*/\n"
"\n"
"/*\n"
".directory h3.swap {\n"
"	height: 61px;\n"
"	background-repeat: no-repeat;\n"
"	background-image: url(\"yourimage.gif\");\n"
"}\n"
".directory h3.swap span {\n"
"	display: none;\n"
"}\n"
"*/\n"
"\n"
".directory > h3 {\n"
"	margin-top: 0;\n"
"}\n"
"\n"
".directory p {\n"
"	margin: 0px;\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
".directory div {\n"
"	display: none;\n"
"	margin: 0px;\n"
"}\n"
"\n"
".directory img {\n"
"	vertical-align: -30%;\n"
"}\n"
"\n"
"/* these are for tree view when not used as main index */\n"
"\n"
".directory-alt {\n"
"	font-size: 100%;\n"
"	font-weight: bold;\n"
"}\n"
"\n"
".directory-alt h3 {\n"
"	margin: 0px;\n"
"	margin-top: 1em;\n"
"	font-size: 11pt;\n"
"}\n"
"\n"
".directory-alt > h3 {\n"
"	margin-top: 0;\n"
"}\n"
"\n"
".directory-alt p {\n"
"	margin: 0px;\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
".directory-alt div {\n"
"	display: none;\n"
"	margin: 0px;\n"
"}\n"
"\n"
".directory-alt img {\n"
"	vertical-align: -30%;\n"
"}\n"
"\n"
"/* @end */\n"
"\n"
"div.dynheader {\n"
"        margin-top: 8px;\n"
"}\n"
"\n"
"address {\n"
"	font-style: normal;\n"
"	color: ##33;\n"
"}\n"
"\n"
"table.doxtable {\n"
"	border-collapse:collapse;\n"
"}\n"
"\n"
"table.doxtable td, table.doxtable th {\n"
"	border: 1px solid ##37;\n"
"	padding: 3px 7px 2px;\n"
"}\n"
"\n"
"table.doxtable th {\n"
"	background-color: ##47;\n"
"	color: #FFFFFF;\n"
"	font-size: 110%;\n"
"	padding-bottom: 4px;\n"
"	padding-top: 5px;\n"
"	text-align:left;\n"
"}\n"
"\n"
".tabsearch {\n"
"	top: 0px;\n"
"	left: 10px;\n"
"	height: 36px;\n"
"	background-image: url('tab_b.png');\n"
"	z-index: 101;\n"
"	overflow: hidden;\n"
"	font-size: 13px;\n"
"}\n"
"\n"
".navpath ul\n"
"{\n"
"	font-size: 11px;\n"
"	background-image:url('tab_b.png');\n"
"	background-repeat:repeat-x;\n"
"	height:30px;\n"
"	line-height:30px;\n"
"	color:##9b;\n"
"	border:solid 1px ##ca;\n"
"	overflow:hidden;\n"
"	margin:0px;\n"
"	padding:0px;\n"
"}\n"
"\n"
".navpath li\n"
"{\n"
"	list-style-type:none;\n"
"	float:left;\n"
"	padding-left:10px;\n"
"	padding-right: 15px;\n"
"	background-image:url('bc_s.png');\n"
"	background-repeat:no-repeat;\n"
"	background-position:right;\n"
"	color:##45;\n"
"}\n"
"\n"
".navpath a\n"
"{\n"
"	height:32px;\n"
"	display:block;\n"
"	text-decoration: none;\n"
"	outline: none;\n"
"}\n"
"\n"
".navpath a:hover\n"
"{\n"
"	color:##80;\n"
"}\n"
"\n"
"div.summary\n"
"{\n"
"	float: right;\n"
"	font-size: 8pt;\n"
"	padding-right: 5px;\n"
"	width: 50%;\n"
"	text-align: right;\n"
"}       \n"
"\n"
"div.summary a\n"
"{\n"
"	white-space: nowrap;\n"
"}\n"
"\n"
"div.header\n"
"{\n"
"        background-image:url('nav_h.png');\n"
"        background-repeat:repeat-x;\n"
"	background-color: ##FA;\n"
"	margin:  0px;\n"
"	border-bottom: 1px solid ##CC;\n"
"}\n"
"\n"
"div.headertitle\n"
"{\n"
"	padding: 5px 5px 5px 10px;\n"
"}\n"
"\n"
