/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.IndexedSeq;
import clojure.lang.Reflector;
import clojure.lang.Util;
import java.lang.reflect.Array;

public class ArraySeq
extends ASeq
implements IndexedSeq,
IReduce {
    final Object array;
    final int i;
    final Object[] oa;

    public static ArraySeq create() {
        return null;
    }

    public static ArraySeq create(Object ... array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return new ArraySeq(array, 0);
    }

    static ISeq createFromObject(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return null;
        }
        Class<?> aclass = array.getClass();
        if (aclass == int[].class) {
            return new ArraySeq_int(null, (int[])array, 0);
        }
        if (aclass == float[].class) {
            return new ArraySeq_float(null, (float[])array, 0);
        }
        if (aclass == double[].class) {
            return new ArraySeq_double(null, (double[])array, 0);
        }
        if (aclass == long[].class) {
            return new ArraySeq_long(null, (long[])array, 0);
        }
        if (aclass == byte[].class) {
            return new ArraySeq_byte(null, (byte[])array, 0);
        }
        if (aclass == char[].class) {
            return new ArraySeq_char(null, (char[])array, 0);
        }
        if (aclass == boolean[].class) {
            return new ArraySeq_boolean(null, (boolean[])array, 0);
        }
        return new ArraySeq(array, 0);
    }

    ArraySeq(Object array, int i) {
        this.array = array;
        this.i = i;
        this.oa = (Object[])(array instanceof Object[] ? array : null);
    }

    ArraySeq(IPersistentMap meta, Object array, int i) {
        super(meta);
        this.array = array;
        this.i = i;
        this.oa = (Object[])(array instanceof Object[] ? array : null);
    }

    public Object first() {
        if (this.oa != null) {
            return this.oa[this.i];
        }
        return Reflector.prepRet(Array.get(this.array, this.i));
    }

    public ISeq next() {
        if (this.oa != null ? this.i + 1 < this.oa.length : this.i + 1 < Array.getLength(this.array)) {
            return new ArraySeq(this.array, this.i + 1);
        }
        return null;
    }

    public int count() {
        if (this.oa != null) {
            return this.oa.length - this.i;
        }
        return Array.getLength(this.array) - this.i;
    }

    public int index() {
        return this.i;
    }

    public ArraySeq withMeta(IPersistentMap meta) {
        return new ArraySeq(meta, this.array, this.i);
    }

    public Object reduce(IFn f) throws Exception {
        if (this.oa != null) {
            Object ret = this.oa[this.i];
            for (int x = this.i + 1; x < this.oa.length; ++x) {
                ret = f.invoke(ret, this.oa[x]);
            }
            return ret;
        }
        Object ret = Reflector.prepRet(Array.get(this.array, this.i));
        for (int x = this.i + 1; x < Array.getLength(this.array); ++x) {
            ret = f.invoke(ret, Reflector.prepRet(Array.get(this.array, x)));
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) throws Exception {
        if (this.oa != null) {
            Object ret = f.invoke(start, this.oa[this.i]);
            for (int x = this.i + 1; x < this.oa.length; ++x) {
                ret = f.invoke(ret, this.oa[x]);
            }
            return ret;
        }
        Object ret = f.invoke(start, Reflector.prepRet(Array.get(this.array, this.i)));
        for (int x = this.i + 1; x < Array.getLength(this.array); ++x) {
            ret = f.invoke(ret, Reflector.prepRet(Array.get(this.array, x)));
        }
        return ret;
    }

    public int indexOf(Object o) {
        if (this.oa != null) {
            for (int j = this.i; j < this.oa.length; ++j) {
                if (!Util.equals(o, this.oa[j])) continue;
                return j - this.i;
            }
        } else {
            int n = Array.getLength(this.array);
            for (int j = this.i; j < n; ++j) {
                if (!Util.equals(o, Reflector.prepRet(Array.get(this.array, j)))) continue;
                return j - this.i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (this.oa != null) {
            if (o == null) {
                for (int j = this.oa.length - 1; j >= this.i; --j) {
                    if (this.oa[j] != null) continue;
                    return j - this.i;
                }
            } else {
                for (int j = this.oa.length - 1; j >= this.i; --j) {
                    if (!o.equals(this.oa[j])) continue;
                    return j - this.i;
                }
            }
        } else if (o == null) {
            for (int j = Array.getLength(this.array) - 1; j >= this.i; --j) {
                if (Reflector.prepRet(Array.get(this.array, j)) != null) continue;
                return j - this.i;
            }
        } else {
            for (int j = Array.getLength(this.array) - 1; j >= this.i; --j) {
                if (!o.equals(Reflector.prepRet(Array.get(this.array, j)))) continue;
                return j - this.i;
            }
        }
        return -1;
    }

    public static class ArraySeq_boolean
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final boolean[] array;
        final int i;

        ArraySeq_boolean(IPersistentMap meta, boolean[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_boolean(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_boolean withMeta(IPersistentMap meta) {
            return new ArraySeq_boolean(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Boolean) {
                boolean b = (Boolean)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Boolean) {
                boolean b = (Boolean)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_char
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final char[] array;
        final int i;

        ArraySeq_char(IPersistentMap meta, char[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return Character.valueOf(this.array[this.i]);
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_char(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_char withMeta(IPersistentMap meta) {
            return new ArraySeq_char(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = Character.valueOf(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Character.valueOf(this.array[x]));
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, Character.valueOf(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Character.valueOf(this.array[x]));
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (c != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(Character.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (c != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(Character.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_byte
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final byte[] array;
        final int i;

        ArraySeq_byte(IPersistentMap meta, byte[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_byte(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_byte withMeta(IPersistentMap meta) {
            return new ArraySeq_byte(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Byte) {
                byte b = (Byte)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Byte) {
                byte b = (Byte)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_long
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final long[] array;
        final int i;

        ArraySeq_long(IPersistentMap meta, long[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_long(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_long withMeta(IPersistentMap meta) {
            return new ArraySeq_long(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Long) {
                long l = (Long)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (l != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Long) {
                long l = (Long)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (l != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_double
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final double[] array;
        final int i;

        ArraySeq_double(IPersistentMap meta, double[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_double(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_double withMeta(IPersistentMap meta) {
            return new ArraySeq_double(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Double) {
                double d = (Double)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (d != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Double) {
                double d = (Double)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (d != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_float
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final float[] array;
        final int i;

        ArraySeq_float(IPersistentMap meta, float[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return Float.valueOf(this.array[this.i]);
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_float(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_float withMeta(IPersistentMap meta) {
            return new ArraySeq_float(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = Float.valueOf(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Float.valueOf(this.array[x]));
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, Float.valueOf(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Float.valueOf(this.array[x]));
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Float) {
                float f = ((Float)o).floatValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (f != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(Float.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Float) {
                float f = ((Float)o).floatValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (f != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(Float.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_int
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final int[] array;
        final int i;

        ArraySeq_int(IPersistentMap meta, int[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_int(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_int withMeta(IPersistentMap meta) {
            return new ArraySeq_int(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public int indexOf(Object o) {
            if (o instanceof Integer) {
                int k = (Integer)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (k != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (o instanceof Integer) {
                int k = (Integer)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (k != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }
}

