/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_LIBRARY_H_
#define _OPENSHIVA_LIBRARY_H_

#include <GTLCore/String.h>
#include <OpenShiva/Export.h>
#include <map>

namespace GTLCore {
  class CompilationMessage;
  class CompilationMessages;
  class ModuleData;
  class Function;
  class Value;
}

namespace OpenShiva {
  class Source;
  class Metadata;
  /**
   * @ingroup OpenShiva
   *
   * Represent a Shiva Library, it is also the base class for kernels.<
   */
  class OPENSHIVA_EXPORT Library {
    friend class Kernel;
    friend struct KernelPrivate;
    friend class LibrariesManager;
      Library( bool _isKernel, int _channelsNb );
      ~Library();
      GTL_NO_COPY(Library);
    public:
      /**
       * @return the name of the kernel
       */
      GTLCore::String name() const;
      /**
       * Set the code source of the module.
       */
      void setSource(const GTLCore::String& source);
      void setSource(const Source& source);
      Source source() const;
      /**
       * Load the module from the given file name.
       */
      void loadFromFile(const GTLCore::String& fileName);
      /**
       * Start the compilation of the module.
       */
      void compile();
      /**
       * @return true if the module was successfully compiled.
       */
      bool isCompiled() const;
      /**
       * @return a string with the content of the compilation error.
       */
      const GTLCore::CompilationMessages& compilationMessages() const;
      /**
       * @return the assembly source code, it's mostly usefull for testing purpose
       */
      GTLCore::String asmSourceCode() const;
      /**
       * @return a pointer to the internal Data of this module (the class Module::Data
       *         is not part of the public API and therefore there is no reason
       *         to use this function).
       */
      const GTLCore::ModuleData* data() const;
      /**
       * @return the list of functions available in this module.
       */
      std::list<GTLCore::Function*> functions();
      /**
       * @return the metadata for this kernel.
       */
      const Metadata* metadata() const;
    private:
      void cleanup();
    private:
      struct Private;
      Private* const d;
  };
}

#endif
