/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_LIBRARY_MANAGER_H_
#define _OPENSHIVA_LIBRARY_MANAGER_H_

#include <GTLCore/String.h>
#include <OpenShiva/Export.h>

namespace {
  class StaticPointerLibrariesManager;
}

namespace OpenShiva {
  class Library;
  /**
   * @ingroup OpenShiva
   *
   * Manage the different @ref Library that are used by the kernels.
   */
  class OPENSHIVA_EXPORT LibrariesManager {
      friend class ::StaticPointerLibrariesManager;
    private:
      LibrariesManager();
      ~LibrariesManager();
      GTL_NO_COPY(LibrariesManager);
    public:
      /**
       * @return a library if it's already loaded or return 0
       */
      Library* library(const GTLCore::String& name, int _channelsNb);
      /**
       * Add a directory to the list of directory that get searched for library.
       */
      void addDirectory(const GTLCore::String& directory);
      void registerLibrary(const GTLCore::String& name, Library* );
      /**
       * Load a library with the given name.
       */
      Library* loadLibrary( const GTLCore::String& filename, int _channelsNb);
    public:
      /**
       * @return the instance to the singleton \ref LibraryManager
       */
      static LibrariesManager* instance();
    private:
      struct Private;
      Private* const d;
  };
  
};

#endif
