/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "../MemoryManager_p.h"

#include <cstring>

#define COUMPONENT_NAME "GTLCore test"

class TestMemoryManager : public GTLTest::Case {
  public:
    TestMemoryManager() : GTLTest::Case("MemoryManager")
    {
    }
    virtual void runTest()
    {
      int countAlloc = 10000;
      std::vector<void*> allocated;
      std::vector<int> sizes;
      for(int i = 0; i < countAlloc; ++i)
      {
        int size = rand() / 1000000;
        void* m = GTLCore::MemoryManager::allocate(size);
        GTLTEST_CHECK_REQUIRED(m);
        char counter = i;
        memset(m, counter, size);
        allocated.push_back(m);
        sizes.push_back(size);
      }
      GTLTEST_CHECK_REQUIRED( allocated.size() == sizes.size() );
      int error = 0;
      for(int i = 0; i < countAlloc; ++i)
      {
        void* ptr = allocated[i];
        int size = sizes[i];
        error += checkArray(ptr, i, size);
      }
      GTLTEST_CHECK_EQUAL(error, 0);
      for(int i = 0; i < countAlloc; ++i)
      {
        void* ptr = allocated[i];
        GTLCore::MemoryManager::desallocate(ptr);
      }
    }
  private:
    int checkArray( void* ptr, char v, int size)
    {
      char* ptr8 = reinterpret_cast<char*>(ptr);
      int error = 0;
      for(int j = 0; j < size; ++j)
      {
        if( ptr8[j] != v )
        {
          GTL_DEBUG( (int)ptr8[j] << " " << (int)v );
          ++error;
        }
      }
      return error;
    }
};
