// import "TestFramework";

const float exposure = 0.982091;
const float lightTable[][2] = { {0,0},{1,1} };
const float redTable[][2] = { {0,0},{1,1} };
const float greenTable[][2] = { {0,0},{1,1} };
const float blueTable[][2] = { {0,0},{1,1} };
const float inputBlackValue = 0;
const float inputWhiteValue = 1;
const float inputGamma = 1;
const float outputBlackValue = 0;
const float outputWhiteValue = 1;
float intToFloat( int v ) {   return v / 65535.0; }
int floatToInt( float v ) {
  if( v > 1.0 ) return 65535;
  else if( v < 0.0 ) return 0; return v * 65535;
}
float adjustLevel( float v ) {
  if( v < inputBlackValue )  {
    return outputBlackValue;
  } else if( v > inputWhiteValue ) {
    return outputWhiteValue;
  }
  float a = (v - inputBlackValue) / (inputWhiteValue - inputBlackValue);
  a = (outputWhiteValue - outputBlackValue) * pow(a, (1.0 / inputGamma));
  return (outputBlackValue + a);
}

void apply( int rIn, int gIn, int bIn, output int rOut, output int gOut, output int bOut)
{
  rOut = floatToInt( interpolateCubic1D( redTable, interpolateCubic1D( lightTable, adjustLevel( intToFloat(rIn) ) * exposure ) ) );
  gOut = floatToInt( interpolateCubic1D( greenTable, interpolateCubic1D( lightTable, adjustLevel( intToFloat(gIn) ) * exposure ) ));
  bOut = floatToInt( interpolateCubic1D( blueTable, interpolateCubic1D( lightTable, adjustLevel( intToFloat(bIn) ) * exposure ) ) );
}

int main()
{
  int errorcount = 0;
  int r = 10; int g = 100; int b = 12;
  int or; int og; int ob;
  apply(r, g, b, or, og, ob );
}
