/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

//Own
#include "grubdeviceeditor.h"

//Qt
#include <qvalidator.h>

//KDE
#include <klineedit.h>
#include <klocale.h>
#include <kmenu.h>
#include <kpushbutton.h>

//KGRUBEditor
#include "core/path.h"

GRUBDeviceEditor::GRUBDeviceEditor( QWidget *parent ) : KHBox( parent )
{
	m_edit = new KLineEdit( this );
	m_edit->setClearButtonShown( true );
	m_button = new KPushButton( KIcon( "tools-wizard" ), i18nc( "@action:button", "Suggestions" ), this );
	m_menu = new KMenu( m_button );
	m_button->setMenu( m_menu );
	connect( m_menu, SIGNAL( triggered( QAction * ) ), SLOT( suggestionTriggered( QAction * ) ) );

	setMode( None );
}

GRUBDeviceEditor::Modes GRUBDeviceEditor::mode() const
{
	return m_mode;
}
void GRUBDeviceEditor::setMode( GRUBDeviceEditor::Modes mode )
{
	switch( mode )
	{
		case None:
			m_edit->setValidator( 0 );
			m_menu->clear();
		break;
		case Device:
			m_edit->setValidator( new QRegExpValidator( QRegExp( "(\\([fhn]d\\d(\\d)?\\))" ), this ) );
			m_menu->clear();
			m_menu->addTitle( i18nc( "@title:menu", "Devices" ) );
			foreach( const GRUB::Misc::Device device, Core::Devices::DeviceList )
				if ( !deviceAlreadyExists( m_menu, device.device() ) )
					m_menu->addAction( device.device() )->setData( device.grubDevice() );
		break;
		case Partition:
			m_edit->setValidator( new QRegExpValidator( QRegExp( "(\\([fhn]d\\d(\\d)?,\\d(\\d)?\\))" ), this ) );
			m_menu->clear();
			m_menu->addTitle( i18nc( "@title:menu", "Partitions" ) );
			foreach( const GRUB::Misc::Device device, Core::Devices::DeviceList )
				m_menu->addAction( device.partition() + QString( " (" ) + device.mountPoint() + QString( ")" ) )->setData( device.grubPartition() );
		break;
		case All:
			m_edit->setValidator( new QRegExpValidator( QRegExp( "(\\([fhn]d\\d(\\d)?(,\\d(\\d)?)?\\))" ), this ) );
			m_menu->clear();
			m_menu->addTitle( i18nc( "@title:menu", "Devices" ) );
			foreach( const GRUB::Misc::Device device, Core::Devices::DeviceList )
				if ( !deviceAlreadyExists( m_menu, device.device() ) )
					m_menu->addAction( device.device() )->setData( device.grubDevice() );
			m_menu->addTitle( i18nc( "@title:menu", "Partitions" ) );
			foreach( const GRUB::Misc::Device device, Core::Devices::DeviceList )
				m_menu->addAction( device.partition() + QString( " (" ) + device.mountPoint() + QString( ")" ) )->setData( device.grubPartition() );
		break;
	}
	m_mode = mode;
}

KLineEdit* GRUBDeviceEditor::lineEdit() const
{
	return m_edit;
}
KPushButton* GRUBDeviceEditor::button() const
{
	return m_button;
}
KMenu* GRUBDeviceEditor::menu() const
{
	return m_menu;
}

bool GRUBDeviceEditor::deviceAlreadyExists( const KMenu *menu, const QString &device ) const
{
	foreach( const QAction *action, menu->actions() )
		if ( action->text() == device )
			return true;
	return false;
}

void GRUBDeviceEditor::suggestionTriggered( QAction *action )
{
	m_edit->setText( action->data().toString() );
}

#include "grubdeviceeditor.moc"
