#!/bin/sh

testdir="$1"
#sroot=/home/$USER/11srv
sroot=/export/rmeggins/11srv
port=1100
secport=1101
rootdn="cn=directory manager"
rootpw=password
#adminpw=boguspassword
adminpw=admin
#needinstance=1
needdata=1
#usessl=1
secdir=/path/to/etc/fedora-ds/slapd-localhost
PATH=/usr/lib64/mozldap:$PATH
export PATH

if [ "$needinstance" ] ; then
$sroot/bin/ds_newinst.pl - <<EOF
[General]
FullMachineName=   localhost.localdomain
SuiteSpotUserID=   $USER
ServerRoot=    $sroot/lib/fedora-ds
[slapd]
ServerPort=   $port
ServerIdentifier=   localhost
Suffix=   o=NetscapeRoot
RootDN=   $rootdn
RootDNPwd=  $rootpw
EOF
fi

if [ "$needdata" ] ; then
$sroot/lib/fedora-ds/slapd-localhost/ldif2db.pl -D "$rootdn" -w "$rootpw" -n userRoot -i $testdir/nsroot.ldif
sleep 10
fi

rm -rf testtmp
mkdir testtmp

if [ "$usessl" ] ; then
    ldapurl="ldaps://localhost:$secport/o=NetscapeRoot"
else
    ldapurl="ldap://localhost:$port/o=NetscapeRoot"
fi

cat > testtmp/adm.conf <<EOF
ldapurl:    $ldapurl
ldapHost:   localhost.localdomain
ldapPort:   $port
sie:   cn=admin-serv-localhost, cn=Fedora Administration Server, cn=Server Group, cn=localhost.localdomain, ou=localdomain, o=NetscapeRoot
isie:   cn=Fedora Administration Server, cn=Server Group, cn=localhost.localdomain, ou=localdomain, o=NetscapeRoot
port:   32348
ldapStart:   slapd-localhost/start-slapd
EOF

cat > testtmp/admpw <<EOF
admin:{SHA}0DPiKuNIrrVmD8IUCuw1hQxNqZc=
EOF

pwpfile=/tmp/pwp.$$
PASSWORD_PIPE=0 ; export PASSWORD_PIPE
cat > $pwpfile <<EOF
User: admin
Password: $adminpw

UserDN: uid=admin, ou=Administrators, ou=TopologyManagement, o=NetscapeRoot
SIEPWD: $adminpw
EOF

dir=`pwd`

cat > .gdbinit <<EOF
break main
run $dir/testtmp $secdir < $pwpfile
EOF

VALGRIND="valgrind --log-file=/var/tmp/vg.out --tool=memcheck --leak-check=yes --suppressions=/home/rmeggins/valgrind.supp --num-callers=40 "
GDB="gdb -x .gdbinit "

NOSSLTESTS="retrieveSIE psetread psetwrite"
SSLTESTS="retrieveSIEssl psetreadssl"
if [ "$usessl" ] ; then
    TESTS="$SSLTESTS"
else
    TESTS="$NOSSLTESTS"
fi
for test in $TESTS ; do
#    ./libtool --mode execute $GDB ./$test
    cat $pwpfile | ./libtool --mode execute $VALGRIND ./$test $dir/testtmp $secdir
done

rm -f $pwpfile .gdbinit
