
########################################################
# K3D_CHECK_X86 - tests to see if we're building for an x86 platform

AC_DEFUN([K3D_CHECK_X86], [
AC_MSG_CHECKING([for an x86 CPU])

if echo $target_cpu | grep "i.86" >/dev/null 2>/dev/null; then
	AC_MSG_RESULT([found $x86])
	AC_DEFINE([K3D_HAVE_X86], [1], [Define to 1 if you are building for an architecture that uses an Intel x86 CPU])
else
	AC_MSG_RESULT([not found])
fi

])

########################################################
# K3D_CHECK_VARARGS - handles per-platform behavior for varargs macros

AC_DEFUN([K3D_CHECK_VARARGS], [
	AC_MSG_CHECKING([for va_copy() or __va_copy])
	
	AC_LINK_IFELSE([
		#include <stdarg.h>
		int main(int argc, char* argv[])
		{
			va_list ap1,ap2;
			va_copy(ap1,ap2);
			return 0;
		}
		],
		[k3d_have_va_copy=yes], [k3d_have_va_copy=no])

	AC_LINK_IFELSE([
		#include <stdarg.h>
		int main(int argc, char* argv[])
		{
			va_list ap1,ap2;
			__va_copy(ap1,ap2);
			return 0;
		}
		],
		[k3d_have___va_copy=yes], [k3d___have_va_copy=no])

	if test x"$k3d_have_va_copy" = x"yes"; then
		AC_DEFINE(HAVE_VA_COPY, 1, [Define to 1 if either va_copy or __va_copy is available])
		AC_DEFINE(VA_COPY, va_copy, [Define to the specific version of va_copy or __va_copy that is available])
		AC_MSG_RESULT([found va_copy])
	elif test x"$k3d_have___va_copy" = x"yes"; then
		AC_DEFINE(HAVE_VA_COPY, 1, [Define to 1 if either va_copy or __va_copy is available])
		AC_DEFINE(VA_COPY, __va_copy, [Define to the specific version of va_copy or __va_copy that is available])
		AC_MSG_RESULT([found __va_copy])
	else
		AC_MSG_RESULT([found neither])
	fi
])

########################################################
# K3D_CHECK_PLATFORM - tests to see what platform we're building on - posix, darwin, etc.

AC_DEFUN([K3D_CHECK_PLATFORM], [
AC_SUBST(host)
AC_MSG_CHECKING([for platform])

case $host in
  *-*-darwin*)
  	AC_MSG_RESULT([found Darwin (including Mac OS-X)])
	AC_DEFINE([K3D_PLATFORM_DARWIN], [1], [Define to 1 if you are building K-3D on Darwin (including Mac OS-X)])
	k3d_platform_darwin=true
	;;
  *)
	AC_MSG_RESULT([defaulting to posix])
	AC_DEFINE([K3D_PLATFORM_POSIX], [1], [Define to 1 if you are building K-3D on most Posix platforms, including GNU/Linux])
	k3d_platform_posix=true
	;;

esac
])

