/* 
 * Ming/Ruby
 * $Id: swfmovieclip.c,v 1.9 2002/06/18 14:13:34 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_cSWFMovieClip;

void rb_SWFMovieClip_mark(clip)
     struct RSWFMovieClip *clip;
{
  mark_references(clip->table);
  return;
}

static VALUE
rb_SWFMovieClip_s_new(self)
	 VALUE self;
{
  struct RSWFMovieClip *s = ALLOC(struct RSWFMovieClip);
  VALUE obj;

  s->this = newSWFMovieClip();
  s->table = ALLOC(struct References);
  init_references(s->table);
  
  obj = Data_Wrap_Struct(rb_cSWFMovieClip, rb_SWFMovieClip_mark,
			  rb_SWFMovieClip_free, s);

  return obj;
}

void
rb_SWFMovieClip_free(p)
	 struct RSWFMovieClip *p;
{
  destroySWFMovieClip(p->this);
  
  return;  
}

static VALUE
rb_SWFMovieClip_add(self, c)
	 VALUE self, c;
{
  struct RSWFMovieClip *s;
  struct RSWFBlock *b;
  struct RSWFDisplayItem *i;
  SWFDisplayItem item;
  VALUE obj;

  Data_Get_Struct(self, struct RSWFMovieClip, s);
  Data_Get_Struct(c, struct RSWFBlock, b);

  regist_references(s->table, c);
  item = SWFMovieClip_add(s->this, b->this);

  if (item == NULL)
    obj = Qnil;
  else {
    i = ALLOC(struct RSWFDisplayItem);
    i->this = item;
    obj =  Data_Wrap_Struct(rb_cSWFDisplayItem, 0,
	   rb_SWFDisplayItem_free, i);
    regist_references(s->table, obj);
  }

  return obj;
}

static VALUE
rb_SWFMovieClip_remove(self, item)
	 VALUE self, item;
{
  struct RSWFMovieClip *m;
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFMovieClip, m);
  Data_Get_Struct(item, struct RSWFDisplayItem, i);

  regist_references(m->table, item);
  SWFMovieClip_remove(m->this, i->this);

  return self;
}

static VALUE
rb_SWFMovieClip_next_frame(self)
	 VALUE self;
{
  struct RSWFMovieClip *p;

  Data_Get_Struct(self, struct RSWFMovieClip, p);

  SWFMovieClip_nextFrame(p->this);

  return self;
}

static VALUE
rb_SWFMovieClip_set_frames(self, t)
	 VALUE self, t;
{
  struct RSWFMovieClip *m;

  Data_Get_Struct(self, struct RSWFMovieClip, m);

  SWFMovieClip_setNumberOfFrames(m->this, NUM2INT(t));

  return self;
}

static VALUE
rb_SWFMovieClip_label_frame(self, s)
	 VALUE self, s;
{
  struct RSWFMovieClip *m;

  Data_Get_Struct(self, struct RSWFMovieClip, m);

  SWFMovieClip_labelFrame(m->this, STR2CSTR(s));

  return self;
}

static VALUE
rb_SWFMovieClip_set_number_of_frames(self, n)
	 VALUE self, n;
{
  struct RSWFMovieClip *m;

  Data_Get_Struct(self, struct RSWFMovieClip, m);

  SWFMovieClip_setNumberOfFrames(m->this, NUM2INT(n));

  return self;
}

static VALUE
rb_SWFMovieClip_set_sound_stream(self, n, r)
	 VALUE self, n, r;
{
  struct RSWFMovie *m;
  char *name = STR2CSTR(n);
  FILE *fp;
  VALUE path = rb_cv_get(rb_cSWFMovie, "@@mp3_path");
#ifdef SUPPORT_PCM
  SWFSoundStream sound;
#else
  SWFSound sound;
#endif

  fp = search_file(path, name, "rb");

  if (fp == NULL) {
	rb_raise(rb_eIOError, "No such file - %s", name);
  }
  
#ifdef SUPPORT_PCM
  sound = newSWFSoundStream(fp);
#else
  sound = newSWFSound(fp);
#endif
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovieClip_setSoundStream(m->this, sound, NUM2DBL(r));
  
  return self;
}

void Init_swfmovieclip()
{
  rb_cSWFMovieClip = rb_define_class_under(rb_mMing, "SWFMovieClip",
					   rb_cObject);
  rb_define_class_under(rb_mMing, "SWFSprite", rb_cSWFMovieClip);
  
  rb_define_singleton_method(rb_cSWFMovieClip, "new",
							 rb_SWFMovieClip_s_new, 0);

  rb_define_method(rb_cSWFMovieClip, "add",
				   rb_SWFMovieClip_add, 1);
  rb_define_method(rb_cSWFMovieClip, "remove",
				   rb_SWFMovieClip_remove, 1);
  rb_define_method(rb_cSWFMovieClip, "next_frame",
				   rb_SWFMovieClip_next_frame, 0);
  rb_define_method(rb_cSWFMovieClip, "set_frames",
				   rb_SWFMovieClip_set_frames, 1);
  rb_define_method(rb_cSWFMovieClip, "label_frame",
				   rb_SWFMovieClip_label_frame, 1);
  rb_define_method(rb_cSWFMovieClip, "set_number_of_frames",
				   rb_SWFMovieClip_set_number_of_frames, 1);
  rb_define_method(rb_cSWFMovieClip, "set_sound_stream",
				   rb_SWFMovieClip_set_sound_stream, 2);

  return;
}

