/*
 * Ming/Ruby
 * $Id: swfmovie.c,v 1.9 2002/06/27 13:28:07 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_cSWFMovie;

static VALUE
rb_SWFMovie_s_mp3_path(self)
	 VALUE self;
{
  return rb_cv_get(rb_cSWFMovie, "@@mp3_path");
}

static VALUE
rb_SWFMovie_s_set_mp3_path(self, array)
	 VALUE self, array;
{
  rb_cv_set(rb_cSWFMovie, "@@mp3_path", array);
  
  return array;
}

static void rb_SWFMovie_mark(movie)
     struct RSWFMovie *movie;
{
  mark_references(movie->table);

  return;
}

static VALUE
rb_SWFMovie_s_new(argc, argv, self)
	 int argc;
	 VALUE *argv, self;
{
  VALUE obj, version;
  struct RSWFMovie *m = ALLOC(struct RSWFMovie);

  rb_scan_args(argc, argv, "01", &version);

  if(NIL_P(version))
    m->this = newSWFMovie();
  else
    m->this = newSWFMovie(NUM2INT(version));

  m->table = ALLOC(struct References);
  init_references(m->table);
  
  obj = Data_Wrap_Struct(rb_cSWFMovie, rb_SWFMovie_mark,
			  rb_SWFMovie_free, m);
  
  return obj;
}

void
rb_SWFMovie_free(p)
	 struct RSWFMovie *p;
{
  destroySWFMovie(p->this);
  
  return;  
}

static void simpleOutputMethod(byte b, void *data);
static void simpleOutputMethod(b, data)
	 byte b;
	 void *data;
{
  putchar(b);
}

static VALUE
rb_SWFMovie_output(self)
	 VALUE self;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_output(m->this, simpleOutputMethod, NULL);
  
  return self;
}

static VALUE
rb_SWFMovie_save(self, s)
	 VALUE self, s;
{
  struct RSWFMovie *m;
  int count;

  Data_Get_Struct(self, struct RSWFMovie, m);
  count = SWFMovie_save(m->this, STR2CSTR(s));

  return INT2NUM(count);
}

static VALUE
rb_SWFMovie_add(self, b)
	 VALUE self, b;
{
  struct RSWFMovie *m;
  struct RSWFBlock *p;
  struct RSWFDisplayItem *i;
  SWFDisplayItem item;
  VALUE obj;

  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(b, struct RSWFBlock, p);
  
  item = SWFMovie_add(m->this, p->this);

  if (item == NULL) {
    obj = Qnil;
  } else {
    regist_references(m->table, b);
    i = ALLOC(struct RSWFDisplayItem);
    i->this = item;
    
    obj = Data_Wrap_Struct(rb_cSWFDisplayItem, 0,
			   rb_SWFDisplayItem_free, i);
    regist_references(m->table, obj);
  }

  return obj;
}

static VALUE
rb_SWFMovie_remove(self, i)
	 VALUE self, i;
{
  struct RSWFMovie *m;
  struct RSWFDisplayItem *p;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(i, struct RSWFDisplayItem, p);
  
  regist_references(m->table, i);
  SWFMovie_remove(m->this, p->this);

  return self;
}

static VALUE
rb_SWFMovie_next_frame(self)
	 VALUE self;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_nextFrame(m->this);

  return self;
}

static VALUE
rb_SWFMovie_set_background(self, r, g, b)
	 VALUE self, r, g, b;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setBackground(m->this, FIX2INT(r), FIX2INT(g), FIX2INT(b));
  
  return self;
}

static VALUE
rb_SWFMovie_set_rate(self, f)
	 VALUE self, f;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setRate(m->this, (float) NUM2DBL(f));

  return self;
}

static VALUE
rb_SWFMovie_set_dimension(self, w, h)
	 VALUE self, w, h;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setDimension(m->this, (float) NUM2DBL(w), (float) NUM2DBL(h));

  return self;
}

static VALUE
rb_SWFMovie_set_frames(self, t)
     VALUE self, t;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setFrames(m->this, FIX2INT(t));

  return self;
}

static VALUE
rb_SWFMovie_label_frame(self, label)
	 VALUE self, label;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_labelFrame(m->this, STR2CSTR(label));

  return self;
}

static VALUE
rb_SWFMovie_set_number_of_frames(self, n)
	 VALUE self, n;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setNumberOfFrames(m->this, FIX2INT(n));

  return self;
}

static VALUE
rb_SWFMovie_stream_mp3(self, n)
	 VALUE self, n;
{
  struct RSWFMovie *m;
  char *name = STR2CSTR(n);
  FILE *fp;
  VALUE path = rb_cv_get(rb_cSWFMovie, "@@mp3_path");
#ifdef SUPPORT_PCM
  SWFSoundStream sound;
#else
  SWFSound sound;
#endif

  fp = search_file(path, name, "rb");

  if (fp == NULL) {
	rb_raise(rb_eIOError, "No such file - %s", name);
  }

#ifdef SUPPORT_PCM
  sound = newSWFSoundStream(fp);
#else
  sound = newSWFSound(fp);
#endif
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setSoundStream(m->this, sound);
  
  return self;
}

static VALUE
rb_SWFMovie_add_export(self, block, n)
	 VALUE self, block, n;
{
  struct RSWFMovie *m;
  struct RSWFBlock *b;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(block, struct RSWFBlock, b);

  regist_references(m->table, n);
  SWFMovie_addExport(m->this, b->this, STR2CSTR(n));
  
  return self;
}

#ifdef SUPPORT_PCM

static VALUE
rb_SWFMovie_start_sound(self, item)
	 VALUE self, item;
{
  struct RSWFMovie *m;
  struct RSWFDisplayItem *i;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(item, struct RSWFDisplayItem, i);

  regist_references(m->table, item);
  SWFMovie_startSound(m->this, i->this);
  
  return self;
}

static VALUE
rb_SWFMovie_stop_sound(self, item)
	 VALUE self, item;
{
  struct RSWFMovie *m;
  struct RSWFDisplayItem *i;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(item, struct RSWFDisplayItem, i);

  regist_references(m->table, item);
  SWFMovie_stopSound(m->this, i->this);
  
  return self;
}

static VALUE
rb_SWFMovie_add_sound(self, n, f)
	 VALUE self, n, f;
{
  struct RSWFMovie *m;
  struct RSWFDisplayItem *i;
  char *name = STR2CSTR(n);
  FILE *fp;
  VALUE obj, path = rb_cv_get(rb_cSWFMovie, "@@mp3_path");
  SWFSound sound;
  SWFInput input;
  byte flags;

  fp = search_file(path, name, "rb");

  if(fp == NULL) {
	rb_raise(rb_eIOError, "No such file - %s", name);
  }
    
  Data_Get_Struct(self, struct RSWFMovie, m);
  input = newSWFInput_file(fp);
  flags = NUM2INT(f);

  sound = newSWFSound_fromInput(input, flags);

  i = ALLOC(struct RSWFDisplayItem);
  i->this = SWFMovie_add(m->this, sound);
  
  obj = Data_Wrap_Struct(rb_cSWFDisplayItem, 0, rb_SWFDisplayItem_free, i);
  
  return obj;
}

static VALUE
rb_SWFMovie_set_button_sound(self, button, up, over, down, hit)
	 VALUE self, button, up, over, down, hit;
{
  struct RSWFMovie *m;
  struct RSWFDisplayItem *b, *i;
  int t;
  VALUE state[4];
  SWFDisplayItem item[4];
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(button, struct RSWFDisplayItem, b);

  state[0] = up;
  state[1] = over;
  state[2] = down;
  state[3] = hit;

  for(t = 0; t < 4; t++) {
	if(NIL_P(state[t])) {
	  item[t] = NULL;
	} else {
	  Data_Get_Struct(state[t], struct RSWFDisplayItem, i);
	  item[t] = i->this;
	}
  }
  
  regist_references(m->table, button);
  SWFMovie_setButtonSound(m->this, b->this, item);
  
  return self;
}

#endif

void
Init_swfmovie()
{
  rb_cSWFMovie = rb_define_class_under(rb_mMing, "SWFMovie", rb_cObject);

  rb_define_class_variable(rb_cSWFMovie, "@@mp3_path", rb_cArray);
  rb_cv_set(rb_cSWFMovie, "@@mp3_path",
			rb_ary_new3(1, rb_str_new2(".")));
  rb_define_singleton_method(rb_cSWFMovie, "mp3_path",
							 rb_SWFMovie_s_mp3_path, 0);
  rb_define_singleton_method(rb_cSWFMovie, "mp3_path=",
							 rb_SWFMovie_s_set_mp3_path, 1);

  rb_define_singleton_method(rb_cSWFMovie, "new", rb_SWFMovie_s_new, -1);

  rb_define_method(rb_cSWFMovie, "output",
				   rb_SWFMovie_output, 0);
  rb_define_method(rb_cSWFMovie, "save",
				   rb_SWFMovie_save, 1);
  rb_define_method(rb_cSWFMovie, "add",
				   rb_SWFMovie_add, 1);
  rb_define_method(rb_cSWFMovie, "remove",
				   rb_SWFMovie_remove, 1);
  rb_define_method(rb_cSWFMovie, "next_frame",
				   rb_SWFMovie_next_frame, 0);
  rb_define_method(rb_cSWFMovie, "set_background",
				   rb_SWFMovie_set_background, 3);
  rb_define_method(rb_cSWFMovie, "set_rate",
				   rb_SWFMovie_set_rate, 1);
  rb_define_method(rb_cSWFMovie, "set_dimension",
				   rb_SWFMovie_set_dimension, 2);
  rb_define_method(rb_cSWFMovie, "set_frames",
				   rb_SWFMovie_set_frames, 1);
  rb_define_method(rb_cSWFMovie, "label_frame",
				   rb_SWFMovie_label_frame, 1);
  rb_define_method(rb_cSWFMovie, "set_number_of_frames",
				   rb_SWFMovie_set_number_of_frames, 1);
  rb_define_method(rb_cSWFMovie, "stream_mp3",
				   rb_SWFMovie_stream_mp3, 1);
  rb_define_method(rb_cSWFMovie, "add_export",
				   rb_SWFMovie_add_export, 2);

#ifdef SUPPORT_PCM
  rb_define_method(rb_cSWFMovie, "start_sound",
				   rb_SWFMovie_start_sound, 1);
  rb_define_method(rb_cSWFMovie, "stop_sound",
				   rb_SWFMovie_stop_sound, 1);
  rb_define_method(rb_cSWFMovie, "add_sound",
				   rb_SWFMovie_add_sound, 2);
  rb_define_method(rb_cSWFMovie, "set_button_sound",
				   rb_SWFMovie_set_button_sound, 5);
#endif
  
  return;
}
