/*
 * Ming/Ruby
 * $Id: swfgradient.c,v 1.5 2002/06/12 14:44:51 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_cSWFGradient;

static VALUE
rb_SWFGradient_s_new(self)
	 VALUE self;
{
  struct RSWFGradient *g = ALLOC(struct RSWFGradient);
  VALUE obj;

  g->this = newSWFGradient();
  
  obj = Data_Wrap_Struct(rb_cSWFGradient, NULL,
			 rb_SWFGradient_free, g);

  return obj;
}

void
rb_SWFGradient_free(p)
	 struct RSWFGradient *p;
{
  destroySWFGradient(p->this);
  return;
}

static VALUE
rb_SWFGradient_add_entry(argc, argv, self)
	 int argc;
	 VALUE *argv, self;
{
  struct RSWFGradient *p;
  VALUE rt, r, g, b, a;
  float ratio;
  byte red, green, blue, alpha;

  rb_scan_args(argc, argv, "41", &rt, &r, &g, &b, &a);

  ratio = NUM2DBL(rt);
  red   = NUM2CHR(r);
  green = NUM2CHR(g);
  blue  = NUM2CHR(b);

  if (NIL_P(a)) {
	alpha = 0xff;
  } else {
	alpha = NUM2CHR(a);
  }

  Data_Get_Struct(self, struct RSWFGradient, p);
  SWFGradient_addEntry(p->this, ratio, red, green, blue, alpha);

  return self;
}

void
Init_swfgradient()
{
  rb_cSWFGradient = rb_define_class_under(rb_mMing, "SWFGradient",
					  rb_cObject);

  rb_define_singleton_method(rb_cSWFGradient, "new",
			     rb_SWFGradient_s_new, 0);
  rb_define_method(rb_cSWFGradient, "add_entry",
		   rb_SWFGradient_add_entry, -1);

  return;
}
