/*
 * Ming/Ruby
 * $Id: swffont.c,v 1.6 2002/06/24 14:12:12 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_cSWFFont;

static VALUE
rb_SWFFont_s_font_path(self)
	 VALUE self;
{
  return rb_cv_get(rb_cSWFFont, "@@font_path");
}

static VALUE
rb_SWFFont_s_set_font_path(self, array)
	 VALUE self, array;
{
  rb_cv_set(rb_cSWFFont, "@@font_path", array);
  
  return array;
}
  
static VALUE
rb_SWFFont_s_new(self, n)
	 VALUE self, n;
{
  struct RSWFFont *f = ALLOC(struct RSWFFont);
  char *name = STR2CSTR(n), *ext;
  size_t len;
  FILE *fp;
  VALUE obj;

  VALUE path = rb_cv_get(rb_cSWFFont, "@@font_path");
  len = RSTRING(n)->len;

  if(len > 4) {
    ext = &name[RSTRING(n)->len - 4];

    if (strncmp_ignore_case(ext, ".fdb", 4) == 0) {
      fp = search_file(path, name, "rb");
      if (fp != NULL) {
	f->this = loadSWFFontFromFile(fp);
	fclose(fp);
      }
      else
	rb_raise(rb_eIOError, "No such file - %s", name);
    } else {
      f->this = newSWFBrowserFont(name);
    }
  } else {
    f->this = newSWFBrowserFont(name);
  }
  
  obj = Data_Wrap_Struct(rb_cSWFFont, NULL,
			 rb_SWFFont_free, f);
  
  return obj;
}

void
rb_SWFFont_free(p)
     struct RSWFFont *p;
{
  // destroySWFFont(p->this);
  return;
}

static VALUE
rb_SWFFont_get_width(self, s)
	 VALUE self, s;
{
  struct RSWFFont *f;

  Data_Get_Struct(self, struct RSWFFont, f);

  return rb_float_new(SWFFont_getStringWidth(f->this, STR2CSTR(s)));
}

static VALUE
rb_SWFFont_get_ascent(self)
	 VALUE self;
{
  struct RSWFFont *f;

  Data_Get_Struct(self, struct RSWFFont, f);

  return rb_float_new(SWFFont_getAscent(f->this));
}

static VALUE
rb_SWFFont_get_descent(self)
	 VALUE self;
{
  struct RSWFFont *f;

  Data_Get_Struct(self, struct RSWFFont, f);

  return rb_float_new(SWFFont_getDescent(f->this));
}

static VALUE
rb_SWFFont_get_leading(self)
	 VALUE self;
{
  struct RSWFFont *f;

  Data_Get_Struct(self, struct RSWFFont, f);

  return rb_float_new(SWFFont_getLeading(f->this));
}

#ifdef SUPPORT_JAPANESE_BROWSER_FONTS
static VALUE
rb_SWFFont_set_flags(self, flags)
	 VALUE self, flags;
{
  struct RSWFFont *f;

  Data_Get_Struct(self, struct RSWFFont, f);
  SWFBrowserFont_setFlags(f->this, NUM2INT(flags));

  return self;
}
#endif

void Init_swffont()
{
  rb_cSWFFont = rb_define_class_under(rb_mMing, "SWFFont", rb_cObject);

  rb_define_class_variable(rb_cSWFFont, "@@font_path", rb_cArray);
  rb_cv_set(rb_cSWFFont, "@@font_path",
			rb_ary_new3(1, rb_str_new2(".")));
  rb_define_singleton_method(rb_cSWFFont, "font_path",
			     rb_SWFFont_s_font_path, 0);
  rb_define_singleton_method(rb_cSWFFont, "font_path=",
			     rb_SWFFont_s_set_font_path, 1);
  
  
  rb_define_singleton_method(rb_cSWFFont, "new", rb_SWFFont_s_new, 1);
	
  rb_define_method(rb_cSWFFont, "get_width",
				   rb_SWFFont_get_width, 1);
  rb_define_method(rb_cSWFFont, "get_ascent",
				   rb_SWFFont_get_ascent, 0);
  rb_define_method(rb_cSWFFont, "get_descent",
				   rb_SWFFont_get_descent, 0);
  rb_define_method(rb_cSWFFont, "get_leading",
				   rb_SWFFont_get_leading, 0);
#ifdef SUPPORT_JAPANESE_BROWSER_FONTS
  rb_define_method(rb_cSWFFont, "set_flags",
				   rb_SWFFont_set_flags, 1);
#endif
  
  return;
}

