/* 
 * Ming/Ruby
 * $Id: swfdisplayitem.c,v 1.8 2002/06/13 11:04:36 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_cSWFDisplayItem;

void rb_SWFDisplayItem_free(p)
     struct RSWFDisplayItem *p;
{
  // destroySWFDisplayItem(p->this);
  
  return;
}

static VALUE
rb_SWFDisplayItem_move_to(self, x, y)
	 VALUE self, x, y;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_moveTo(i->this, NUM2DBL(x), NUM2DBL(y));

  return self;
}

static VALUE
rb_SWFDisplayItem_move(self, x, y)
	 VALUE self, x, y;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_move(i->this, NUM2DBL(x), NUM2DBL(y));

  return self;
}

static VALUE
rb_SWFDisplayItem_scale_to(argc, argv, self)
	 int argc;
	 VALUE *argv, self;
{
  VALUE x, y;
  struct RSWFDisplayItem *i;

  rb_scan_args(argc, argv, "11", &x, &y);

  Data_Get_Struct(self, struct RSWFDisplayItem, i);

  if (NIL_P(y))
    SWFDisplayItem_scaleTo(i->this, NUM2DBL(x), NUM2DBL(x));
  else
    SWFDisplayItem_scaleTo(i->this, NUM2DBL(x), NUM2DBL(y));

  return self;
}

static VALUE
rb_SWFDisplayItem_scale(self, x, y)
	 VALUE self, x, y;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_scale(i->this, NUM2DBL(x), NUM2DBL(y));

  return self;
}

static VALUE
rb_SWFDisplayItem_rotate_to(self, d)
	 VALUE self, d;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_rotateTo(i->this, NUM2DBL(d));

  return self;
}

static VALUE
rb_SWFDisplayItem_rotate(self, d)
	 VALUE self, d;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_rotate(i->this, NUM2DBL(d));

  return self;
}

static VALUE
rb_SWFDisplayItem_skew_x_to(self, x)
	 VALUE self, x;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_skewXTo(i->this, NUM2DBL(x));

  return self;
}

static VALUE
rb_SWFDisplayItem_skew_x(self, x)
	 VALUE self, x;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_skewX(i->this, NUM2DBL(x));

  return self;
}

static VALUE
rb_SWFDisplayItem_skew_y_to(self, y)
	 VALUE self, y;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_skewYTo(i->this, NUM2DBL(y));

  return self;
}

static VALUE
rb_SWFDisplayItem_skew_y(self, y)
	 VALUE self, y;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_skewY(i->this, NUM2DBL(y));

  return self;
}

static VALUE
rb_SWFDisplayItem_set_depth(self, d)
	 VALUE self, d;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_setDepth(i->this, NUM2DBL(d));

  return self;
}

static VALUE
rb_SWFDisplayItem_remove(self)
	 VALUE self;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_remove(i->this);

  return self;
}

static VALUE
rb_SWFDisplayItem_set_name(self, n)
	 VALUE self, n;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_setName(i->this, STR2CSTR(n));

  return self;
}

static VALUE
rb_SWFDisplayItem_set_ratio(self, r)
	 VALUE self, r;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_setRatio(i->this, NUM2DBL(r));

  return self;
}

static VALUE
rb_SWFDisplayItem_add_color(argc, argv, self)
	 int argc;
	 VALUE *argv, self;
{
  VALUE r, g, b, a;
  int red, green, blue, alpha;
  struct RSWFDisplayItem *i;

  rb_scan_args(argc, argv, "31", &r, &g, &b, &a);

  red   = NUM2INT(r);
  green = NUM2INT(g);
  blue  = NUM2INT(b);

  if(NIL_P(a)) {
	alpha = 0xff;
  } else {
	alpha = NUM2INT(a);
  }

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_addColor(i->this, red, green, blue, alpha);

  return self;
}

static VALUE
rb_SWFDisplayItem_mult_color(argc, argv, self)
	 int argc;
	 VALUE *argv, self;
{
  VALUE r, g, b, a;
  float red, green, blue, alpha;
  struct RSWFDisplayItem *i;

  rb_scan_args(argc, argv, "31", &r, &g, &b, &a);

  red   = NUM2DBL(r);
  green = NUM2DBL(g);
  blue  = NUM2DBL(b);

  if(NIL_P(a)) {
	alpha = 0.0;
  } else {
	alpha = NUM2DBL(a);
  }

  Data_Get_Struct(self, struct RSWFDisplayItem, i);

  SWFDisplayItem_multColor(i->this, red, green, blue, alpha);

  return self;
}

static VALUE
rb_SWFDisplayItem_get_depth(self)
	 VALUE self;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);

  return INT2NUM(SWFDisplayItem_getDepth(i->this));
}

static VALUE
rb_SWFDisplayItem_set_matrix(self, a, b, c, d, x, y)
	 VALUE self, a, b, c, d, x, y;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);

  SWFDisplayItem_setMatrix(i->this, NUM2DBL(a), NUM2DBL(b),
			   NUM2DBL(c), NUM2DBL(d),
			   NUM2DBL(x), NUM2DBL(y));

  return self;
}

static VALUE
rb_SWFDisplayItem_set_mask_level(self, mask)
	 VALUE self, mask;
{
  struct RSWFDisplayItem *i;

  Data_Get_Struct(self, struct RSWFDisplayItem, i);
  SWFDisplayItem_setMaskLevel(i->this, NUM2INT(mask));

  return self;
}

void
Init_swfdisplayitem()
{
  rb_cSWFDisplayItem = rb_define_class_under(rb_mMing,
					     "SWFDisplayItem",
					     rb_cObject);

  rb_define_method(rb_cSWFDisplayItem, "move_to",
				   rb_SWFDisplayItem_move_to, 2);
  rb_define_method(rb_cSWFDisplayItem, "move",
				   rb_SWFDisplayItem_move, 2);
  rb_define_method(rb_cSWFDisplayItem, "scale_to",
				   rb_SWFDisplayItem_scale_to, -1);
  rb_define_method(rb_cSWFDisplayItem, "scale",
				   rb_SWFDisplayItem_scale, 2);
  rb_define_method(rb_cSWFDisplayItem, "rotate_to",
				   rb_SWFDisplayItem_rotate_to, 1);
  rb_define_method(rb_cSWFDisplayItem, "rotate",
				   rb_SWFDisplayItem_rotate, 1);
  rb_define_method(rb_cSWFDisplayItem, "skew_x_to",
				   rb_SWFDisplayItem_skew_x_to, 1);
  rb_define_method(rb_cSWFDisplayItem, "skew_x",
				   rb_SWFDisplayItem_skew_x, 1);
  rb_define_method(rb_cSWFDisplayItem, "skew_y_to",
				   rb_SWFDisplayItem_skew_y_to, 1);
  rb_define_method(rb_cSWFDisplayItem, "skew_y",
				   rb_SWFDisplayItem_skew_y, 1);
  rb_define_method(rb_cSWFDisplayItem, "set_depth",
				   rb_SWFDisplayItem_set_depth, 1);
  rb_define_method(rb_cSWFDisplayItem, "remove",
				   rb_SWFDisplayItem_remove, 0);
  rb_define_method(rb_cSWFDisplayItem, "set_name",
				   rb_SWFDisplayItem_set_name, 1);
  rb_define_method(rb_cSWFDisplayItem, "set_ratio",
				   rb_SWFDisplayItem_set_ratio, 1);
  rb_define_method(rb_cSWFDisplayItem, "add_color",
				   rb_SWFDisplayItem_add_color, -1);
  rb_define_method(rb_cSWFDisplayItem, "mult_color",
				   rb_SWFDisplayItem_mult_color, -1);
  rb_define_method(rb_cSWFDisplayItem, "get_depth",
				   rb_SWFDisplayItem_get_depth, 0);
  rb_define_method(rb_cSWFDisplayItem, "set_matrix",
				   rb_SWFDisplayItem_set_matrix, 6);
  rb_define_method(rb_cSWFDisplayItem, "set_mask_level",
				   rb_SWFDisplayItem_set_mask_level, 1);

  return;
}
