/* 
 *  Ming/Ruby
 *  $Id: swfaction.c,v 1.3 2002/06/06 18:11:48 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_cSWFAction;

void
rb_SWFAction_free(p)
	 struct RSWFAction *p;
{
  // destroySWFAction(p->this);

  return;
}

static VALUE
rb_SWFAction_s_new(self, s)
	 VALUE self, s;
{
  char *script = STR2CSTR(s);
  struct RSWFAction *a = ALLOC(struct RSWFAction);
  VALUE obj;

  a->this = compileSWFActionCode(script);

  if (a->this == NULL)
    rb_raise(rb_eMingError, "Could not compile actionscripts - %s", script);

  obj = Data_Wrap_Struct(rb_cSWFAction, 0,
			 rb_SWFAction_free, a);

  return obj;
}

void
Init_swfaction()
{
  rb_cSWFAction = rb_define_class_under(rb_mMing, "SWFAction", rb_cObject);

  rb_define_singleton_method(rb_cSWFAction, "new",
			     rb_SWFAction_s_new, 1);

  return;
}
