/* 
 * Ming/Ruby
 * $Id: ming.c,v 1.11 2002/06/27 13:28:06 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdarg.h>
#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_mMing;
VALUE rb_eMingError;

static VALUE
rb_Ming_set_scale(self, scale)
	 VALUE self, scale;
{
  Ming_setScale(NUM2DBL(scale));
  
  return self;
}

static VALUE
rb_Ming_get_scale(self)
	 VALUE self;
{
  return rb_float_new(Ming_getScale());
}

static VALUE
rb_Ming_use_SWFVersion(self, version)
	 VALUE self, version;
{
  Ming_useSWFVersion(NUM2INT(version));
  return self;
}

static VALUE
rb_Ming_key_press(self, c)
	 VALUE self, c;
{
  if(TYPE(c) != T_STRING)
	rb_raise(rb_eMingError, "Argument must be a character on keyboard.");
  if(RSTRING(c)->len != 1)
	rb_raise(rb_eMingError, "Size of argument must be just 1.");
  
  return INT2FIX(SWFBUTTON_KEYPRESS(RSTRING(c)->ptr[0]));
}

static VALUE
rb_Ming_on_key_press(self, c)
	 VALUE self, c;
{
  if(TYPE(c) != T_STRING)
	rb_raise(rb_eMingError, "Argument must be character on keyboard.");
  if(RSTRING(c)->len != 1)
	rb_raise(rb_eMingError, "Size of argument must be just 1.");

  return INT2FIX(SWFBUTTON_ONKEYPRESS(RSTRING(c)->ptr[0]));
}

void rb_Ming_raise(char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  rb_raise(rb_eMingError, msg, args);
  va_end(args);
}

void Init_ming()
{
  rb_mMing = rb_define_module("Ming");

  Ming_init();

  rb_eMingError = rb_define_class("MingError", rb_eException);
  setSWFErrorFunction(rb_Ming_raise);

  rb_define_module_function(rb_mMing, "set_scale",
							rb_Ming_set_scale, 1);
  rb_define_module_function(rb_mMing, "get_scale",
							rb_Ming_get_scale, 0);
  rb_define_module_function(rb_mMing, "use_SWFVersion",
							rb_Ming_use_SWFVersion, 1);
  rb_define_module_function(rb_mMing, "key_press",
							rb_Ming_key_press, 1);
  rb_define_module_function(rb_mMing, "on_key_press",
							rb_Ming_on_key_press, 1);
  
  rb_define_const(rb_mMing, "MING_VERSION", rb_str_new2(MING_VERSION_TEXT));

  /* Constants for SWFFill */
  
  rb_define_const(rb_mMing, "SWFFILL_SOLID",
				  INT2NUM(SWFFILL_SOLID));
  rb_define_const(rb_mMing, "SWFFILL_GRADIENT",
				  INT2NUM(SWFFILL_GRADIENT));
  rb_define_const(rb_mMing, "SWFFILL_LINEAR_GRADIENT",
				  INT2NUM(SWFFILL_LINEAR_GRADIENT));
  rb_define_const(rb_mMing, "SWFFILL_RADIAL_GRADIENT",
				  INT2NUM(SWFFILL_RADIAL_GRADIENT));
  rb_define_const(rb_mMing, "SWFFILL_BITMAP",
				  INT2NUM(SWFFILL_BITMAP));
  rb_define_const(rb_mMing, "SWFFILL_TILED_BITMAP",
				  INT2NUM(SWFFILL_TILED_BITMAP));
  rb_define_const(rb_mMing, "SWFFILL_CLIPPED_BITMAP",
				  INT2NUM(SWFFILL_CLIPPED_BITMAP));

  /* Constants for SWFTextField */

  rb_define_const(rb_mMing, "SWFTEXTFIELD_HASLENGTH",
				  INT2NUM(SWFTEXTFIELD_HASLENGTH));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_NOEDIT",
				  INT2NUM(SWFTEXTFIELD_NOEDIT));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_PASSWORD",
				  INT2NUM(SWFTEXTFIELD_PASSWORD));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_MULTILINE",
				  INT2NUM(SWFTEXTFIELD_MULTILINE));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_WORDWRAP",
				  INT2NUM(SWFTEXTFIELD_WORDWRAP));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_DRAWBOX",
				  INT2NUM(SWFTEXTFIELD_DRAWBOX));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_NOSELECT",
				  INT2NUM(SWFTEXTFIELD_NOSELECT));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_HTML",
				  INT2NUM(SWFTEXTFIELD_HTML));

  rb_define_const(rb_mMing, "SWFTEXTFIELD_ALIGN_LEFT",
				  INT2NUM(SWFTEXTFIELD_ALIGN_LEFT));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_ALIGN_RIGHT",
				  INT2NUM(SWFTEXTFIELD_ALIGN_RIGHT));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_ALIGN_CENTER",
				  INT2NUM(SWFTEXTFIELD_ALIGN_CENTER));
  rb_define_const(rb_mMing, "SWFTEXTFIELD_ALIGN_JUSTIFY",
				  INT2NUM(SWFTEXTFIELD_ALIGN_JUSTIFY));

  /* Constants for SWFButton */

  rb_define_const(rb_mMing, "SWFBUTTONRECORD_HITSTATE",
				  INT2NUM(SWFBUTTONRECORD_HITSTATE));
  rb_define_const(rb_mMing, "SWFBUTTONRECORD_DOWNSTATE",
				  INT2NUM(SWFBUTTONRECORD_DOWNSTATE));
  rb_define_const(rb_mMing, "SWFBUTTONRECORD_OVERSTATE",
				  INT2NUM(SWFBUTTONRECORD_OVERSTATE));
  rb_define_const(rb_mMing, "SWFBUTTONRECORD_UPSTATE",
				  INT2NUM(SWFBUTTONRECORD_UPSTATE));

  rb_define_const(rb_mMing, "SWFBUTTON_HIT", CHR2FIX(SWFBUTTON_HIT));
  rb_define_const(rb_mMing, "SWFBUTTON_DOWN", CHR2FIX(SWFBUTTON_DOWN));
  rb_define_const(rb_mMing, "SWFBUTTON_OVER", CHR2FIX(SWFBUTTON_OVER));
  rb_define_const(rb_mMing, "SWFBUTTON_UP", CHR2FIX(SWFBUTTON_UP));
  rb_define_const(rb_mMing, "SWFBUTTON_OVERDOWNTOIDLE",
				  CHR2FIX(SWFBUTTON_OVERDOWNTOIDLE));
  rb_define_const(rb_mMing, "SWFBUTTON_IDLETOOVERDOWN",
				  CHR2FIX(SWFBUTTON_IDLETOOVERDOWN));
  rb_define_const(rb_mMing, "SWFBUTTON_OUTDOWNTOIDLE",
				  CHR2FIX(SWFBUTTON_OUTDOWNTOIDLE));
  rb_define_const(rb_mMing, "SWFBUTTON_OUTDOWNTOOVERDOWN",
				  CHR2FIX(SWFBUTTON_OUTDOWNTOOVERDOWN));
  rb_define_const(rb_mMing, "SWFBUTTON_OVERDOWNTOOUTDOWN",
				  CHR2FIX(SWFBUTTON_OVERDOWNTOOUTDOWN));
  rb_define_const(rb_mMing, "SWFBUTTON_OVERDOWNTOOVERUP",
				  CHR2FIX(SWFBUTTON_OVERDOWNTOOVERUP));
  rb_define_const(rb_mMing, "SWFBUTTON_OVERUPTOOVERDOWN",
				  CHR2FIX(SWFBUTTON_OVERUPTOOVERDOWN));
  rb_define_const(rb_mMing, "SWFBUTTON_OVERUPTOIDLE",
				  CHR2FIX(SWFBUTTON_OVERUPTOIDLE));
  rb_define_const(rb_mMing, "SWFBUTTON_IDLETOOVERUP",
				  CHR2FIX(SWFBUTTON_IDLETOOVERUP));
  rb_define_const(rb_mMing, "SWFBUTTON_MOUSEUPOUTSIDE",
				  CHR2FIX(SWFBUTTON_MOUSEUPOUTSIDE));
  rb_define_const(rb_mMing, "SWFBUTTON_DRAGOVER",
				  CHR2FIX(SWFBUTTON_DRAGOVER));
  rb_define_const(rb_mMing, "SWFBUTTON_DRAGOUT",
				  CHR2FIX(SWFBUTTON_DRAGOUT));
  rb_define_const(rb_mMing, "SWFBUTTON_MOUSEUP",
				  CHR2FIX(SWFBUTTON_MOUSEUP));
  rb_define_const(rb_mMing, "SWFBUTTON_MOUSEDOWN",
				  CHR2FIX(SWFBUTTON_MOUSEDOWN));
  rb_define_const(rb_mMing, "SWFBUTTON_MOUSEOUT",
				  CHR2FIX(SWFBUTTON_MOUSEOUT));
  rb_define_const(rb_mMing, "SWFBUTTON_MOUSEOVER",
				  CHR2FIX(SWFBUTTON_MOUSEOVER));

  rb_define_const(rb_mMing, "SWFPOSITION_SIZE",
				  INT2NUM(SWFPOSITION_SIZE));

  rb_define_const(rb_mMing, "SWFACTION_ONLOAD",
				  INT2NUM(SWFACTION_ONLOAD));
  rb_define_const(rb_mMing, "SWFACTION_ENTERFRAME",
				  INT2NUM(SWFACTION_ENTERFRAME));
  rb_define_const(rb_mMing, "SWFACTION_UNLOAD",
				  INT2NUM(SWFACTION_UNLOAD));
  rb_define_const(rb_mMing, "SWFACTION_MOUSEMOVE",
				  INT2NUM(SWFACTION_MOUSEMOVE));
  rb_define_const(rb_mMing, "SWFACTION_MOUSEDOWN",
				  INT2NUM(SWFACTION_MOUSEDOWN));
  rb_define_const(rb_mMing, "SWFACTION_MOUSEUP",
				  INT2NUM(SWFACTION_MOUSEUP));
  rb_define_const(rb_mMing, "SWFACTION_KEYDOWN",
				  INT2NUM(SWFACTION_KEYDOWN));
  rb_define_const(rb_mMing, "SWFACTION_KEYUP",
				  INT2NUM(SWFACTION_KEYUP));
  rb_define_const(rb_mMing, "SWFACTION_DATA",
				  INT2NUM(SWFACTION_DATA));

#ifdef SUPPORT_PCM
#ifdef SWF_SOUND_COMPRESSION
  rb_define_const(rb_mMing, "SWF_SOUND_COMPRESSION",
				  INT2NUM(SWF_SOUND_COMPRESSION));
  rb_define_const(rb_mMing, "SWF_SOUND_NOT_COMPRESSED",
				  INT2NUM(SWF_SOUND_NOT_COMPRESSED));
  rb_define_const(rb_mMing, "SWF_SOUND_ADPCM_COMPRESSED",
				  INT2NUM(SWF_SOUND_ADPCM_COMPRESSED));
  rb_define_const(rb_mMing, "SWF_SOUND_MP3_COMPRESSED",
				  INT2NUM(SWF_SOUND_MP3_COMPRESSED));
  rb_define_const(rb_mMing, "SWF_SOUND_RATE",
				  INT2NUM(SWF_SOUND_RATE));
  rb_define_const(rb_mMing, "SWF_SOUND_5KHZ",
				  INT2NUM(SWF_SOUND_5KHZ));
  rb_define_const(rb_mMing, "SWF_SOUND_11KHZ",
				  INT2NUM(SWF_SOUND_11KHZ));
  rb_define_const(rb_mMing, "SWF_SOUND_22KHZ",
				  INT2NUM(SWF_SOUND_22KHZ));
  rb_define_const(rb_mMing, "SWF_SOUND_44KHZ",
				  INT2NUM(SWF_SOUND_44KHZ));
  rb_define_const(rb_mMing, "SWF_SOUND_BITS",
				  INT2NUM(SWF_SOUND_BITS));
  rb_define_const(rb_mMing, "SWF_SOUND_8BITS",
				  INT2NUM(SWF_SOUND_8BITS));
  rb_define_const(rb_mMing, "SWF_SOUND_16BITS",
				  INT2NUM(SWF_SOUND_16BITS));
  rb_define_const(rb_mMing, "SWF_SOUND_CHANNELS",
				  INT2NUM(SWF_SOUND_BITS));
  rb_define_const(rb_mMing, "SWF_SOUND_MONO",
				  INT2NUM(SWF_SOUND_MONO));
  rb_define_const(rb_mMing, "SWF_SOUND_STEREO",
				  INT2NUM(SWF_SOUND_STEREO));
#endif
#ifdef SWFSOUND_COMPRESSION
  rb_define_const(rb_mMing, "SWFSOUND_COMPRESSION",
				  INT2NUM(SWFSOUND_COMPRESSION));
  rb_define_const(rb_mMing, "SWFSOUND_NOT_COMPRESSED",
				  INT2NUM(SWFSOUND_NOT_COMPRESSED));
  rb_define_const(rb_mMing, "SWFSOUND_ADPCM_COMPRESSED",
				  INT2NUM(SWFSOUND_ADPCM_COMPRESSED));
  rb_define_const(rb_mMing, "SWFSOUND_MP3_COMPRESSED",
				  INT2NUM(SWFSOUND_MP3_COMPRESSED));
  rb_define_const(rb_mMing, "SWFSOUND_RATE",
				  INT2NUM(SWFSOUND_RATE));
  rb_define_const(rb_mMing, "SWFSOUND_5KHZ",
				  INT2NUM(SWFSOUND_5KHZ));
  rb_define_const(rb_mMing, "SWFSOUND_11KHZ",
				  INT2NUM(SWFSOUND_11KHZ));
  rb_define_const(rb_mMing, "SWFSOUND_22KHZ",
				  INT2NUM(SWFSOUND_22KHZ));
  rb_define_const(rb_mMing, "SWFSOUND_44KHZ",
				  INT2NUM(SWFSOUND_44KHZ));
  rb_define_const(rb_mMing, "SWFSOUND_BITS",
				  INT2NUM(SWFSOUND_BITS));
  rb_define_const(rb_mMing, "SWFSOUND_8BITS",
				  INT2NUM(SWFSOUND_8BITS));
  rb_define_const(rb_mMing, "SWFSOUND_16BITS",
				  INT2NUM(SWFSOUND_16BITS));
  rb_define_const(rb_mMing, "SWFSOUND_CHANNELS",
				  INT2NUM(SWFSOUND_BITS));
  rb_define_const(rb_mMing, "SWFSOUND_MONO",
				  INT2NUM(SWFSOUND_MONO));
  rb_define_const(rb_mMing, "SWFSOUND_STEREO",
				  INT2NUM(SWFSOUND_STEREO));
#endif
#endif

#ifdef SUPPORT_JAPANESE_BROWSER_FONTS
  rb_define_const(rb_mMing, "SWFFONT_SHIFTJIS",
				  INT2NUM(SWFFONT_SHIFTJIS));
  rb_define_const(rb_mMing, "SWFFONT_UNICODE",
				  INT2NUM(SWFFONT_UNICODE));
  rb_define_const(rb_mMing, "SWFFONT_ANSI",
				  INT2NUM(SWFFONT_ANSI));
  rb_define_const(rb_mMing, "SWFFONT_WIDEOFFSETS",
				  INT2NUM(SWFFONT_WIDEOFFSETS));
  rb_define_const(rb_mMing, "SWFFONT_WIDECODES",
				  INT2NUM(SWFFONT_WIDECODES));
  rb_define_const(rb_mMing, "SWFFONT_ISBOLD",
				  INT2NUM(SWFFONT_ISBOLD));
  rb_define_const(rb_mMing, "SWFFONT_ISITALIC",
				  INT2NUM(SWFFONT_ISITALIC));
#endif

  Init_swfmovie();
  Init_swfshape();
  Init_swfdisplayitem();
  Init_swfgradient();
  Init_swfbitmap();
  Init_swffill();
  Init_swfmorph();
  Init_swftext();
  Init_swffont();
  Init_swftextfield();
  Init_swfmovieclip();
  Init_swfbutton();
  Init_swfaction();

  return;
}
