#!/usr/bin/env ruby
#
# newbutton.rb -- IKEGAMI Daisuke
# original is http://ming.sourceforge.net/examples/example.php?name=newbutton
# $Log$

require 'ming/ming'
include Ming

def rect(r, g, b)
  s = SWFShape.new
  s.set_right_fill(s.add_fill(r, g, b))
  s.draw_line(100, 0)
  s.draw_line(0, 100)
  s.draw_line(-100, 0)
  s.draw_line(0, -100)

  s
end

b = SWFButton.new
b.add_shape(rect(0xff, 0, 0), SWFBUTTON_UP | SWFBUTTON_HIT)
b.add_shape(rect(0, 0xff, 0), SWFBUTTON_OVER)
b.add_shape(rect(0, 0, 0xff), SWFBUTTON_DOWN)

b.add_action(SWFAction.new("_root.label = 'SWFBUTTON_MOUSEUP';"),
	        SWFBUTTON_MOUSEUP)

b.add_action(SWFAction.new("_root.label = 'SWFBUTTON_MOUSEDOWN';"),
             SWFBUTTON_MOUSEDOWN)

b.add_action(SWFAction.new("_root.label = 'SWFBUTTON_MOUSEOVER';"),
             SWFBUTTON_MOUSEOVER)

b.add_action(SWFAction.new("_root.label = 'SWFBUTTON_MOUSEOUT';"),
             SWFBUTTON_MOUSEOUT)

b.add_action(SWFAction.new("_root.label = 'SWFBUTTON_MOUSEUPOUTSIDE';"),
             SWFBUTTON_MOUSEUPOUTSIDE)

b.add_action(SWFAction.new("_root.label = 'SWFBUTTON_DRAGOVER';"),
             SWFBUTTON_DRAGOVER)

b.add_action(SWFAction.new("_root.label = 'SWFBUTTON_DRAGOUT';"),
             SWFBUTTON_DRAGOUT)

m = SWFMovie.new
m.set_dimension(320, 240)

t = SWFTextField.new
t.set_font(SWFFont.new('_serif'))
t.add_string('NO ACTION')
t.set_height(20)
t.set_bounds(320, 20)
t.set_name('label')

i = m.add(t)
i.move_to(20, 200)

i = m.add(b)
i.move_to(20, 40)

m.save('newbutton.swf')
