/*
              Copyright (C) 1993 - 2001   Masahito Yamaga

Permission to use, copy, and distribute this package and its documentation
for any purpose is granted, provided that this permission notice is included
in supporting documentation.

Permission to modify this package is also granted, but please send an e-mail
to Yamaga (ma@yama-ga.com) in case of distributing the modified code.

This package provides NO WARRANTY. You can use this at your own risks.

Copyrights on this package belong to Masahito Yamaga, but GNUPLOT's to Mr.
Thomas Williams and Mr. Colin Kelley (See "Copyright" in the original GNUPLOT
source package).

Distribution of GNUPLOT that has been applied this patch to (especially
binaries) has to be very carefully done. See "Copyright" in the original
GNUPLOT source package.

                                   2001/01/11 Masahito Yamaga(ma@yama-ga.com)
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#ifdef NO_STDLIB_H
char *getenv();
#else
#include <stdlib.h> /* for getenv() */
#endif
#include "gp+lib.h"

extern FILE *gpoutfile;

#ifdef __STDC__
void read_myplot(void)
#else
read_myplot()
#endif
{
	static char *mylib, *myplot, tmp[BUFSIZ];
	FILE *fp;

	if ( !(mylib = getenv("GPPLUS")) )
		if (getenv("HOME")) {
			sprintf(tmp, "%s/bin", getenv("HOME"));
			mylib = tmp;
		}
		else mylib = "";

	if (fp = fopen("myplot","r")) {
		fprintf(gpoutfile,"%%%% User Customization\n");
		fprintf(gpoutfile,"%%%% data from \"./myplot\"\n");
		while(fgets(tmp,MAXLEN,fp)!=NULL) fprintf(gpoutfile,"%s",tmp);
		fclose(fp);
	}
	else {
		sprintf(tmp, "%s/myplot", mylib);
		myplot = tmp;

		if ((fp=fopen(myplot,"r"))!=NULL) {
			fprintf(gpoutfile,"%%%% User Customization\n");
			fprintf(gpoutfile,"%%%% data from \"%s\"\n",myplot);
			while(fgets(tmp,MAXLEN,fp)!=NULL) fprintf(gpoutfile,"%s",tmp);
			fclose(fp);
		}
	}
}
