package metadata

import (
	"encoding/json"
	"fmt"
	"strings"
)

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See NOTICE.txt in the project root for license information.

type Scenario string

const (
	ScenarioAlerts Scenario = "Alerts"
)

func PossibleValuesForScenario() []string {
	return []string{
		string(ScenarioAlerts),
	}
}

func (s *Scenario) UnmarshalJSON(bytes []byte) error {
	var decoded string
	if err := json.Unmarshal(bytes, &decoded); err != nil {
		return fmt.Errorf("unmarshaling: %+v", err)
	}
	out, err := parseScenario(decoded)
	if err != nil {
		return fmt.Errorf("parsing %q: %+v", decoded, err)
	}
	*s = *out
	return nil
}

func parseScenario(input string) (*Scenario, error) {
	vals := map[string]Scenario{
		"alerts": ScenarioAlerts,
	}
	if v, ok := vals[strings.ToLower(input)]; ok {
		return &v, nil
	}

	// otherwise presume it's an undefined value and best-effort it
	out := Scenario(input)
	return &out, nil
}
