/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.client.LinkInfo;
import org.jrobin.mrtg.client.Resources;
import org.jrobin.mrtg.client.RouterInfo;
import org.jrobin.mrtg.client.ServerInfo;

class TreeRenderer
extends DefaultTreeCellRenderer {
    private static ImageIcon MRTG_ICON;
    private static ImageIcon ROUTER_ICON;
    private static ImageIcon LINK_ICON;
    private static ImageIcon INACTIVE_ROUTER_ICON;
    private static ImageIcon INACTIVE_LINK_ICON;

    TreeRenderer() {
        this.setLeafIcon(null);
        this.setClosedIcon(null);
        this.setOpenIcon(null);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof ServerInfo) {
            this.setFont(this.getFont().deriveFont(1));
            this.setIcon(MRTG_ICON);
        } else if (object2 instanceof RouterInfo) {
            this.setFont(this.getFont().deriveFont(1));
            RouterInfo routerInfo = (RouterInfo)object2;
            this.setIcon(routerInfo.isActive() ? ROUTER_ICON : INACTIVE_ROUTER_ICON);
        } else if (object2 instanceof LinkInfo) {
            this.setFont(this.getFont().deriveFont(0));
            LinkInfo linkInfo = (LinkInfo)object2;
            this.setIcon(linkInfo.isActive() ? LINK_ICON : INACTIVE_LINK_ICON);
        } else {
            this.setFont(this.getFont().deriveFont(0));
        }
        return this;
    }

    static {
        try {
            MRTG_ICON = Resources.getImageIcon("res/mrtg/mrtg.png");
            ROUTER_ICON = Resources.getImageIcon("res/mrtg/router.png");
            LINK_ICON = Resources.getImageIcon("res/mrtg/link.png");
            INACTIVE_ROUTER_ICON = Resources.getImageIcon("res/mrtg/router_inactive.png");
            INACTIVE_LINK_ICON = Resources.getImageIcon("res/mrtg/link_inactive.png");
        }
        catch (MrtgException mrtgException) {
            mrtgException.printStackTrace();
        }
    }
}

