/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners.index;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.inject.Named;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceScanner;
import org.sonatype.guice.bean.scanners.QualifiedTypeListener;
import org.sonatype.guice.bean.scanners.QualifiedTypeVisitor;
import org.sonatype.guice.bean.scanners.index.AbstractSisuIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SisuIndex
extends AbstractSisuIndex
implements QualifiedTypeListener {
    public static final String NAMED = Named.class.getName();
    private final File targetDirectory;

    public SisuIndex(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public static void main(String[] args) {
        ArrayList<URL> indexPath = new ArrayList<URL>(args.length);
        for (String path : args) {
            try {
                indexPath.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                Logs.warn("Bad classpath element: {}", path, e);
            }
        }
        ClassLoader parent = SisuIndex.class.getClassLoader();
        URL[] urls = indexPath.toArray(new URL[indexPath.size()]);
        ClassLoader loader = urls.length > 0 ? URLClassLoader.newInstance(urls, parent) : parent;
        new SisuIndex(new File(".")).index(new URLClassSpace(loader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(ClassSpace space) {
        try {
            new ClassSpaceScanner(space).accept(new QualifiedTypeVisitor(this));
        }
        finally {
            this.flushIndex();
        }
    }

    @Override
    public void hear(Annotation qualifier, Class<?> qualifiedType, Object source) {
        this.addClassToIndex(NAMED, qualifiedType.getName());
    }

    @Override
    protected void info(String message) {
        System.out.println("[INFO] " + message);
    }

    @Override
    protected void warn(String message) {
        System.out.println("[WARN] " + message);
    }

    @Override
    protected Reader getReader(String path) throws IOException {
        return new FileReader(new File(this.targetDirectory, path));
    }

    @Override
    protected Writer getWriter(String path) throws IOException {
        File index = new File(this.targetDirectory, path);
        File parent = index.getParentFile();
        if (parent.isDirectory() || parent.mkdirs()) {
            return new FileWriter(index);
        }
        throw new IOException("Error creating: " + parent);
    }
}

