/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the SearchEndEntitiesRestRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SearchEndEntitiesRestRequest{}

// SearchEndEntitiesRestRequest struct for SearchEndEntitiesRestRequest
type SearchEndEntitiesRestRequest struct {
	// Maximum number of results
	MaxNumberOfResults *int32 `json:"max_number_of_results,omitempty"`
	// Current page number
	CurrentPage *int32 `json:"current_page,omitempty"`
	// A List of search criteria.
	Criteria             []SearchEndEntityCriteriaRestRequest `json:"criteria,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _SearchEndEntitiesRestRequest SearchEndEntitiesRestRequest

// NewSearchEndEntitiesRestRequest instantiates a new SearchEndEntitiesRestRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSearchEndEntitiesRestRequest() *SearchEndEntitiesRestRequest {
	this := SearchEndEntitiesRestRequest{}
	return &this
}

// NewSearchEndEntitiesRestRequestWithDefaults instantiates a new SearchEndEntitiesRestRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSearchEndEntitiesRestRequestWithDefaults() *SearchEndEntitiesRestRequest {
	this := SearchEndEntitiesRestRequest{}
	return &this
}

// GetMaxNumberOfResults returns the MaxNumberOfResults field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestRequest) GetMaxNumberOfResults() int32 {
	if o == nil || isNil(o.MaxNumberOfResults) {
		var ret int32
		return ret
	}
	return *o.MaxNumberOfResults
}

// GetMaxNumberOfResultsOk returns a tuple with the MaxNumberOfResults field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestRequest) GetMaxNumberOfResultsOk() (*int32, bool) {
	if o == nil || isNil(o.MaxNumberOfResults) {
		return nil, false
	}
	return o.MaxNumberOfResults, true
}

// HasMaxNumberOfResults returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestRequest) HasMaxNumberOfResults() bool {
	if o != nil && !isNil(o.MaxNumberOfResults) {
		return true
	}

	return false
}

// SetMaxNumberOfResults gets a reference to the given int32 and assigns it to the MaxNumberOfResults field.
func (o *SearchEndEntitiesRestRequest) SetMaxNumberOfResults(v int32) {
	o.MaxNumberOfResults = &v
}

// GetCurrentPage returns the CurrentPage field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestRequest) GetCurrentPage() int32 {
	if o == nil || isNil(o.CurrentPage) {
		var ret int32
		return ret
	}
	return *o.CurrentPage
}

// GetCurrentPageOk returns a tuple with the CurrentPage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestRequest) GetCurrentPageOk() (*int32, bool) {
	if o == nil || isNil(o.CurrentPage) {
		return nil, false
	}
	return o.CurrentPage, true
}

// HasCurrentPage returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestRequest) HasCurrentPage() bool {
	if o != nil && !isNil(o.CurrentPage) {
		return true
	}

	return false
}

// SetCurrentPage gets a reference to the given int32 and assigns it to the CurrentPage field.
func (o *SearchEndEntitiesRestRequest) SetCurrentPage(v int32) {
	o.CurrentPage = &v
}

// GetCriteria returns the Criteria field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestRequest) GetCriteria() []SearchEndEntityCriteriaRestRequest {
	if o == nil || isNil(o.Criteria) {
		var ret []SearchEndEntityCriteriaRestRequest
		return ret
	}
	return o.Criteria
}

// GetCriteriaOk returns a tuple with the Criteria field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestRequest) GetCriteriaOk() ([]SearchEndEntityCriteriaRestRequest, bool) {
	if o == nil || isNil(o.Criteria) {
		return nil, false
	}
	return o.Criteria, true
}

// HasCriteria returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestRequest) HasCriteria() bool {
	if o != nil && !isNil(o.Criteria) {
		return true
	}

	return false
}

// SetCriteria gets a reference to the given []SearchEndEntityCriteriaRestRequest and assigns it to the Criteria field.
func (o *SearchEndEntitiesRestRequest) SetCriteria(v []SearchEndEntityCriteriaRestRequest) {
	o.Criteria = v
}

func (o SearchEndEntitiesRestRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SearchEndEntitiesRestRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.MaxNumberOfResults) {
		toSerialize["max_number_of_results"] = o.MaxNumberOfResults
	}
	if !isNil(o.CurrentPage) {
		toSerialize["current_page"] = o.CurrentPage
	}
	if !isNil(o.Criteria) {
		toSerialize["criteria"] = o.Criteria
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *SearchEndEntitiesRestRequest) UnmarshalJSON(bytes []byte) (err error) {
	varSearchEndEntitiesRestRequest := _SearchEndEntitiesRestRequest{}

	if err = json.Unmarshal(bytes, &varSearchEndEntitiesRestRequest); err == nil {
		*o = SearchEndEntitiesRestRequest(varSearchEndEntitiesRestRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "max_number_of_results")
		delete(additionalProperties, "current_page")
		delete(additionalProperties, "criteria")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableSearchEndEntitiesRestRequest struct {
	value *SearchEndEntitiesRestRequest
	isSet bool
}

func (v NullableSearchEndEntitiesRestRequest) Get() *SearchEndEntitiesRestRequest {
	return v.value
}

func (v *NullableSearchEndEntitiesRestRequest) Set(val *SearchEndEntitiesRestRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableSearchEndEntitiesRestRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableSearchEndEntitiesRestRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSearchEndEntitiesRestRequest(val *SearchEndEntitiesRestRequest) *NullableSearchEndEntitiesRestRequest {
	return &NullableSearchEndEntitiesRestRequest{value: val, isSet: true}
}

func (v NullableSearchEndEntitiesRestRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSearchEndEntitiesRestRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
