﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/PhoneNumberCountryCode.h>
#include <aws/connect/model/PhoneNumberType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {

/**
 * <p>Information about available phone numbers.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AvailableNumberSummary">AWS
 * API Reference</a></p>
 */
class AvailableNumberSummary {
 public:
  AWS_CONNECT_API AvailableNumberSummary() = default;
  AWS_CONNECT_API AvailableNumberSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API AvailableNumberSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The phone number. Phone numbers are formatted <code>[+] [country code]
   * [subscriber number including area code]</code>.</p>
   */
  inline const Aws::String& GetPhoneNumber() const { return m_phoneNumber; }
  inline bool PhoneNumberHasBeenSet() const { return m_phoneNumberHasBeenSet; }
  template <typename PhoneNumberT = Aws::String>
  void SetPhoneNumber(PhoneNumberT&& value) {
    m_phoneNumberHasBeenSet = true;
    m_phoneNumber = std::forward<PhoneNumberT>(value);
  }
  template <typename PhoneNumberT = Aws::String>
  AvailableNumberSummary& WithPhoneNumber(PhoneNumberT&& value) {
    SetPhoneNumber(std::forward<PhoneNumberT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ISO country code.</p>
   */
  inline PhoneNumberCountryCode GetPhoneNumberCountryCode() const { return m_phoneNumberCountryCode; }
  inline bool PhoneNumberCountryCodeHasBeenSet() const { return m_phoneNumberCountryCodeHasBeenSet; }
  inline void SetPhoneNumberCountryCode(PhoneNumberCountryCode value) {
    m_phoneNumberCountryCodeHasBeenSet = true;
    m_phoneNumberCountryCode = value;
  }
  inline AvailableNumberSummary& WithPhoneNumberCountryCode(PhoneNumberCountryCode value) {
    SetPhoneNumberCountryCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of phone number.</p>
   */
  inline PhoneNumberType GetPhoneNumberType() const { return m_phoneNumberType; }
  inline bool PhoneNumberTypeHasBeenSet() const { return m_phoneNumberTypeHasBeenSet; }
  inline void SetPhoneNumberType(PhoneNumberType value) {
    m_phoneNumberTypeHasBeenSet = true;
    m_phoneNumberType = value;
  }
  inline AvailableNumberSummary& WithPhoneNumberType(PhoneNumberType value) {
    SetPhoneNumberType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_phoneNumber;
  bool m_phoneNumberHasBeenSet = false;

  PhoneNumberCountryCode m_phoneNumberCountryCode{PhoneNumberCountryCode::NOT_SET};
  bool m_phoneNumberCountryCodeHasBeenSet = false;

  PhoneNumberType m_phoneNumberType{PhoneNumberType::NOT_SET};
  bool m_phoneNumberTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
