﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {
class ListReportsResult {
 public:
  AWS_CODEBUILD_API ListReportsResult() = default;
  AWS_CODEBUILD_API ListReportsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEBUILD_API ListReportsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> During a previous call, the maximum number of items that can be returned is
   * the value specified in <code>maxResults</code>. If there more items in the list,
   * then a unique string called a <i>nextToken</i> is returned. To get the next
   * batch of items in the list, call this operation again, adding the next token to
   * the call. To get all of the items in the list, keep calling this operation with
   * each subsequent next token that is returned, until no more next tokens are
   * returned. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListReportsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The list of returned ARNs for the reports in the current Amazon Web Services
   * account. </p>
   */
  inline const Aws::Vector<Aws::String>& GetReports() const { return m_reports; }
  template <typename ReportsT = Aws::Vector<Aws::String>>
  void SetReports(ReportsT&& value) {
    m_reportsHasBeenSet = true;
    m_reports = std::forward<ReportsT>(value);
  }
  template <typename ReportsT = Aws::Vector<Aws::String>>
  ListReportsResult& WithReports(ReportsT&& value) {
    SetReports(std::forward<ReportsT>(value));
    return *this;
  }
  template <typename ReportsT = Aws::String>
  ListReportsResult& AddReports(ReportsT&& value) {
    m_reportsHasBeenSet = true;
    m_reports.emplace_back(std::forward<ReportsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListReportsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<Aws::String> m_reports;
  bool m_reportsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
