﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/auditmanager/AuditManagerRequest.h>
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/auditmanager/model/ShareRequestType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace AuditManager {
namespace Model {

/**
 */
class DeleteAssessmentFrameworkShareRequest : public AuditManagerRequest {
 public:
  AWS_AUDITMANAGER_API DeleteAssessmentFrameworkShareRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteAssessmentFrameworkShare"; }

  AWS_AUDITMANAGER_API Aws::String SerializePayload() const override;

  AWS_AUDITMANAGER_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The unique identifier for the share request to be deleted.</p>
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  inline bool RequestIdHasBeenSet() const { return m_requestIdHasBeenSet; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteAssessmentFrameworkShareRequest& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the share request is a sent request or a received
   * request.</p>
   */
  inline ShareRequestType GetRequestType() const { return m_requestType; }
  inline bool RequestTypeHasBeenSet() const { return m_requestTypeHasBeenSet; }
  inline void SetRequestType(ShareRequestType value) {
    m_requestTypeHasBeenSet = true;
    m_requestType = value;
  }
  inline DeleteAssessmentFrameworkShareRequest& WithRequestType(ShareRequestType value) {
    SetRequestType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;

  ShareRequestType m_requestType{ShareRequestType::NOT_SET};
  bool m_requestTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace AuditManager
}  // namespace Aws
