/*
 * BitBucket Server Code Insights API
 *
 * BitBucket Server Code Insights API
 *
 * API version: 1.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package insights

import (
	"encoding/json"
)

// Annotation struct for Annotation
type Annotation struct {
	// The path of the file on which this annotation should be placed. This is the path of the file relative to the git repository
	Path string `json:"path"`
	// The line number that the annotation should belong to. For file-level annotations, the line number should be 0
	Line int32 `json:"line"`
	// The message to display to users. The maximum length accepted is 2000 characters, however the user interface may truncate this value for display purposes. We recommend that the message is short and succinct, with further details available to the user if needed on the page linked to by the the annotation link.
	Message string `json:"message"`
	// The severity of the annotation
	Severity string `json:"severity"`
	// An http or https URL representing the location of the annotation in the external tool
	Link *string `json:"link,omitempty"`
	// The type of annotation posted
	Type *string `json:"type,omitempty"`
	// If the caller requires a link to get or modify this annotation, then an ID must be provided. It is not used or required by Bitbucket, but only by the annotation creator for updating or deleting this specific annotation.
	ExternalId *string `json:"externalId,omitempty"`
}

// NewAnnotation instantiates a new Annotation object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAnnotation(path string, line int32, message string, severity string) *Annotation {
	this := Annotation{}
	this.Path = path
	this.Line = line
	this.Message = message
	this.Severity = severity
	return &this
}

// NewAnnotationWithDefaults instantiates a new Annotation object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAnnotationWithDefaults() *Annotation {
	this := Annotation{}
	return &this
}

// GetPath returns the Path field value
func (o *Annotation) GetPath() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Path
}

// GetPathOk returns a tuple with the Path field value
// and a boolean to check if the value has been set.
func (o *Annotation) GetPathOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Path, true
}

// SetPath sets field value
func (o *Annotation) SetPath(v string) {
	o.Path = v
}

// GetLine returns the Line field value
func (o *Annotation) GetLine() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Line
}

// GetLineOk returns a tuple with the Line field value
// and a boolean to check if the value has been set.
func (o *Annotation) GetLineOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Line, true
}

// SetLine sets field value
func (o *Annotation) SetLine(v int32) {
	o.Line = v
}

// GetMessage returns the Message field value
func (o *Annotation) GetMessage() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Message
}

// GetMessageOk returns a tuple with the Message field value
// and a boolean to check if the value has been set.
func (o *Annotation) GetMessageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Message, true
}

// SetMessage sets field value
func (o *Annotation) SetMessage(v string) {
	o.Message = v
}

// GetSeverity returns the Severity field value
func (o *Annotation) GetSeverity() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Severity
}

// GetSeverityOk returns a tuple with the Severity field value
// and a boolean to check if the value has been set.
func (o *Annotation) GetSeverityOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Severity, true
}

// SetSeverity sets field value
func (o *Annotation) SetSeverity(v string) {
	o.Severity = v
}

// GetLink returns the Link field value if set, zero value otherwise.
func (o *Annotation) GetLink() string {
	if o == nil || o.Link == nil {
		var ret string
		return ret
	}
	return *o.Link
}

// GetLinkOk returns a tuple with the Link field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Annotation) GetLinkOk() (*string, bool) {
	if o == nil || o.Link == nil {
		return nil, false
	}
	return o.Link, true
}

// HasLink returns a boolean if a field has been set.
func (o *Annotation) HasLink() bool {
	if o != nil && o.Link != nil {
		return true
	}

	return false
}

// SetLink gets a reference to the given string and assigns it to the Link field.
func (o *Annotation) SetLink(v string) {
	o.Link = &v
}

// GetType returns the Type field value if set, zero value otherwise.
func (o *Annotation) GetType() string {
	if o == nil || o.Type == nil {
		var ret string
		return ret
	}
	return *o.Type
}

// GetTypeOk returns a tuple with the Type field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Annotation) GetTypeOk() (*string, bool) {
	if o == nil || o.Type == nil {
		return nil, false
	}
	return o.Type, true
}

// HasType returns a boolean if a field has been set.
func (o *Annotation) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// SetType gets a reference to the given string and assigns it to the Type field.
func (o *Annotation) SetType(v string) {
	o.Type = &v
}

// GetExternalId returns the ExternalId field value if set, zero value otherwise.
func (o *Annotation) GetExternalId() string {
	if o == nil || o.ExternalId == nil {
		var ret string
		return ret
	}
	return *o.ExternalId
}

// GetExternalIdOk returns a tuple with the ExternalId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Annotation) GetExternalIdOk() (*string, bool) {
	if o == nil || o.ExternalId == nil {
		return nil, false
	}
	return o.ExternalId, true
}

// HasExternalId returns a boolean if a field has been set.
func (o *Annotation) HasExternalId() bool {
	if o != nil && o.ExternalId != nil {
		return true
	}

	return false
}

// SetExternalId gets a reference to the given string and assigns it to the ExternalId field.
func (o *Annotation) SetExternalId(v string) {
	o.ExternalId = &v
}

func (o Annotation) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["path"] = o.Path
	}
	if true {
		toSerialize["line"] = o.Line
	}
	if true {
		toSerialize["message"] = o.Message
	}
	if true {
		toSerialize["severity"] = o.Severity
	}
	if o.Link != nil {
		toSerialize["link"] = o.Link
	}
	if o.Type != nil {
		toSerialize["type"] = o.Type
	}
	if o.ExternalId != nil {
		toSerialize["externalId"] = o.ExternalId
	}
	return json.Marshal(toSerialize)
}

type NullableAnnotation struct {
	value *Annotation
	isSet bool
}

func (v NullableAnnotation) Get() *Annotation {
	return v.value
}

func (v *NullableAnnotation) Set(val *Annotation) {
	v.value = val
	v.isSet = true
}

func (v NullableAnnotation) IsSet() bool {
	return v.isSet
}

func (v *NullableAnnotation) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAnnotation(val *Annotation) *NullableAnnotation {
	return &NullableAnnotation{value: val, isSet: true}
}

func (v NullableAnnotation) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAnnotation) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
